<?php

namespace Drupal\asciidoc_display;

/**
 * Interface for Asciidoc parser service.
 */
interface AsciidocParserInterface {

  /**
   * Parses a "bare" HTML output from AsciiDoc.
   *
   * Assumes the bare HTML file was made with the scripts/bare.xsl style sheet.
   *
   * @param string $html
   *   HTML to parse. Assumed not to be empty.
   * @param array $options
   *   Associative array of options for parsing, with (all optional) elements:
   *   - keep_toc: TRUE if this page should display the table of contents. If
   *     FALSE (default), the table of contents is removed from the page. In
   *     either case, the table of contents is returned in the return array.
   *  - toc_active: Add an "active" class to table of contents links pointing to
   *    this location, if it is provided. If not provided, the HTML for the table
   *    of contents is left as it was.
   *  - highlight_php: Apply standard PHP syntax highlighting for PHP code, if
   *    set to TRUE. (Default is FALSE.)
   * - link_prefix: If provided, add this prefix to all link URLs that point to
   *   pages within the book. (Default is empty.)
   * - image_prefix: If provided, add this prefix to image source URLs that point
   *   to local images.
   * - parse_parents: If set to TRUE (FALSE is the default), parse the table of
   *   contents (assumed to be called on the full index.html file) and make an
   *   array of parents in the hierarchy.
   * - remove_h1_titles: If set to TRUE (FALSE is the default), remove all H1
   *   elements with class "title" in the document (to avoid duplication with the
   *   page title).
   * - remove_h2_titles: If set to TRUE (FALSE is the default), remove all H2
   *   elements with class "title" in the document (to avoid duplication with the
   *   page title).
   * - remove_source_line: If set to TRUE (FALSE is the default), after locating
   *   the line giving the source file, remove it from the output.
   *
   * @return \Drupal\asciidoc_display\AsciidocItem
   */
  public function parseBareHtml(string $html, array $options = []);

}
