<?php /**
 * @file
 * Contains \Drupal\asciidoc_display\Controller\DefaultController.
 */

namespace Drupal\asciidoc_display\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Link;

/**
 * Default controller for the asciidoc_display module.
 */
class DefaultController extends ControllerBase {

  public function mainAdmin() {

    $build = [];

    // @FIXME
    // l() expects a Url object, created from a route name or external URI.
    // $clear = l(t('Clear book cache'), 'admin/config/development/asciidoc/clear_cache');

    $clear = Link::createFromRoute('Clear book cache', 'asciidoc_display.clear_cache');
    $build['clear'] = $clear->toRenderable();

    return $build;
  }

  public function clearCachePage() {
    asciidoc_display_clear_calculation_caches();
    $this->messenger()->addMessage($this->t('Book cache cleared'));
    return $this->redirect('asciidoc_display.main_admin');
  }

}
