<?xml version="1.0" encoding="ASCII"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exsl="http://exslt.org/common" xmlns:cf="http://docbook.sourceforge.net/xmlns/chunkfast/1.0" xmlns:ng="http://docbook.org/docbook-ng" xmlns:db="http://docbook.org/ns/docbook" xmlns="http://www.w3.org/1999/xhtml" version="1.0" exclude-result-prefixes="exsl cf ng db">

<!-- This file contains overrides for the asciidoc_display module, for use
     in the xmlto command, to affect how XHTML output is created from DocBook
     generated by AsciiDoc. See script mkoutput.sh for usage. -->

<!-- Use item IDs as file names, for portability as content shifts. -->
<xsl:variable name="use.id.as.filename">
  <xsl:value-of select="'1'" />
</xsl:variable>

<!-- Set the maximum depth for tables of contents to 2. -->
<xsl:variable name="toc.max.depth">
  <xsl:value-of select="'2'" />
</xsl:variable>

<!-- Use UL lists for tables of contents, not DL lists. -->
<xsl:variable name="toc.list.type">
  <xsl:value-of select="'ul'" />
</xsl:variable>

<!-- Omit a troublesome span in the TOC line. -->
<xsl:template name="toc.line">
  <xsl:param name="toc-context" select="."/>
  <xsl:param name="depth" select="1"/>
  <xsl:param name="depth.from.context" select="8"/>

  <!-- * if $autotoc.label.in.hyperlink is zero, then output the label -->
  <!-- * before the hyperlinked title (as the DSSSL stylesheet does) -->
  <xsl:if test="$autotoc.label.in.hyperlink = 0">
    <xsl:variable name="label">
      <xsl:apply-templates select="." mode="label.markup"/>
    </xsl:variable>
    <xsl:copy-of select="$label"/>
    <xsl:if test="$label != ''">
      <xsl:value-of select="$autotoc.label.separator"/>
    </xsl:if>
  </xsl:if>

  <a>
    <xsl:attribute name="href">
      <xsl:call-template name="href.target">
        <xsl:with-param name="context" select="$toc-context"/>
        <xsl:with-param name="toc-context" select="$toc-context"/>
      </xsl:call-template>
    </xsl:attribute>

  <!-- * if $autotoc.label.in.hyperlink is non-zero, then output the label -->
  <!-- * as part of the hyperlinked title -->
  <xsl:if test="not($autotoc.label.in.hyperlink = 0)">
    <xsl:variable name="label">
      <xsl:apply-templates select="." mode="label.markup"/>
    </xsl:variable>
    <xsl:copy-of select="$label"/>
    <xsl:if test="$label != ''">
      <xsl:value-of select="$autotoc.label.separator"/>
    </xsl:if>
  </xsl:if>

    <xsl:apply-templates select="." mode="titleabbrev.markup"/>
  </a>
</xsl:template>

<!-- Override the output, to omit HTML headers and put titles in divs. -->
<xsl:template name="chunk-element-content">
  <xsl:param name="prev"/>
  <xsl:param name="next"/>
  <xsl:param name="nav.context"/>
  <xsl:param name="content">
    <xsl:apply-imports/>
  </xsl:param>
  <xsl:variable name="home" select="/*[1]"/>
  <xsl:variable name="this" select="."/>
  <div id="asciidoc-display-book-title">
    <xsl:apply-templates select="$home" mode="object.title.markup.textonly"/>
  </div>
  <div id="asciidoc-display-section-title">
    <xsl:apply-templates select="$this" mode="object.title.markup.textonly"/>
  </div>
  <div class="asciidoc-display-main-content">
    <xsl:copy-of select="$content"/>
    <xsl:call-template name="footer.navigation">
      <xsl:with-param name="prev" select="$prev"/>
      <xsl:with-param name="next" select="$next"/>
      <xsl:with-param name="nav.context" select="$nav.context"/>
    </xsl:call-template>
  </div>
</xsl:template>

<!-- Override the output class for programlistings to give an extra class
     if it is PHP -->
<xsl:template match="programlisting" mode="common.html.attributes">
  <xsl:variable name="programtype" select="./@language" />
  <xsl:choose>
    <xsl:when test="$programtype = 'php'">
      <xsl:attribute name="class">programlisting programlisting-php</xsl:attribute>
    </xsl:when>
    <xsl:otherwise>
      <xsl:attribute name="class">programlisting</xsl:attribute>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
