// $Id: assistant_api.form.ui.js,v 1.1 2010/03/09 16:54:51 pounard Exp $

/**
 * @file
 * jQuery UI additions for Solace API filter form
 */

(function ($) {

Drupal.behaviors.AssistantFormUI = function(context) {
  $('#assistant-api-filters-form', context).each(function(){
    if (! $(this).is('.assistant-form-ui-processed')) {
      new Drupal.AssistantFormUI(this);
      $(this).addClass('assistant-form-ui-processed');
    }
  });
};

Drupal.AssistantFormUI = function(element) {
  var self = this;

  this.previewDialog = false;

  $('input[name=live_preview]', element).click(function() {
    if (! self.previewDialog) {
      self.previewDialog = $('.assistant-dialog-main', element);
      self.previewDialog.dialog({
        'width': 800,
        'height': 400,
        'title': self.previewDialog.children('legend').html(),
        'modal': true
      });
    }
    else {
      $('#assistant-api-filter-form-live-preview', self.previewDialog).html('<img src="' + Drupal.settings.basePath + 'misc/throbber.gif"/>');
      self.previewDialog.dialog('open');
    }
  });
};

})(jQuery);
