<?php
// $Id: ContentAssistantFilter.inc,v 1.1 2010/03/09 16:54:52 pounard Exp $

/**
 * @file
 * Solace CCK filter filters implementation.
 */

class FieldContentAssistantFilter extends AbstractAssistantFilter
{
  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#getTitle()
   */
  public function getTitle() {
    return "Field content";
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#getDescription()
   */
  public function getDescription() {
    return "Allow to filter with field content";
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#isBoostAble()
   */
  public function isBoostAble() {
    return TRUE;
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#_build($context, $values, $query)
   */
  protected function _build(AbstractAssistantContext $context, &$values, SolrQuery $query) {
    // TODO: phrase handling
    if ($values['field']) {
      if ($values['field_value_phrase']) {
        $field = new SolrFieldFilter(_assistant_cck_get_index_key($values['field']), new SolrTerm($values['field_value']));
        $field->setExclusion(SolrOperator::OPERATOR_REQUIRE);
        $query->fq->add($field);
      }
      else {
        $field = new SolrFieldFilter(_assistant_cck_get_index_key($values['field']), new SolrTerm($values['field_value'], $values['boost']));
        $query->q->add($field);
      }
    }
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#_form($context, $values)
   */
  protected function _form(AbstractAssistantContext $context, &$values = array()) {
    $form = array('#prefix' => '<div class="container-inline">', '#suffix' => '</div>');
    $options = array();
    foreach (apachesolr_cck_get_supported_fields() as $field_name => $row) {
      $options[$field_name] = t($row->label);
    }
    $form['field'] = array(
      '#type' => 'select',
      '#default_value' => $values['field'],
      '#options' => $options,
      '#required' => TRUE,
    );
    $this->setAhahProperty($form['field'], 'change');

    if (isset($values['field'])) {
      $field = content_fields($values['field']);
      $allowed_values = content_allowed_values($field);
      if (!empty($allowed_values)) {
        $form['field_value'] = array(
          '#type' => 'select',
          '#options' => $allowed_values,
          '#default_value' => (isset($values['field_value']) ? $values['field_value'] : NULL),
          // '#multiple' => $field['multiple'], // TODO handle this in build function
          '#required' => TRUE,
        );
        $form['field_value_phrase'] = array(
          '#type' => 'hidden',
          '#default_value' => TRUE,
        );
      }
      else {
        $form['field_value'] = array(
          '#type' => 'textfield',
          '#size' => 40,
          '#default_value' => (isset($values['field_value']) ? $values['field_value'] : NULL),
          '#required' => TRUE,
        );
        $form['field_value_phrase'] = array(
          '#type' => 'checkbox',
          '#title' => t('Exact match'),
          '#default_value' => $values['field_value_phrase'],
          '#description' => t("This will force the query to exclude any content that does not matches the exact entered text. Boost will be ignored."),
        );
      }
    }

    return $form;
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#isFilterQuery()
   */
  public function isFilterQuery() {
    return TRUE;
  }
}

class MultipleFieldContentAssistantFilter extends AbstractAssistantFilter
{
  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#getTitle()
   */
  public function getTitle() {
    return "Field content within multiple fields";
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#getDescription()
   */
  public function getDescription() {
    return "Allow to filter with field content, using multiple fields";
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#isBoostAble()
   */
  public function isBoostAble() {
    return TRUE;
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#_build($context, $values, $query)
   */
  protected function _build(AbstractAssistantContext $context, &$values, SolrQuery $query) {
    // TODO: phrase handling
    foreach ($values['field'] as $field_name) {
      if ($field_name) {
        $field = new SolrFieldFilter(
          _assistant_cck_get_index_key($field_name),
          new SolrTerm($values['field_value'], $values['boost'])
        );
        $query->q->add($field);
      }
    }
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#_form($context, $values)
   */
  protected function _form(AbstractAssistantContext $context, &$values = array()) {
    $form = array();
    $options = array();
    foreach (apachesolr_cck_get_supported_fields() as $field_name => $row) {
      $options[$field_name] = t($row->label);
    }
    $form['field'] = array(
      '#type' => 'checkboxes',
      '#default_value' => isset($values['field']) ? $values['field'] : array(),
      '#options' => $options,
      '#required' => TRUE,
    );
    $form['field_value'] = array(
      '#type' => 'textfield',
      '#size' => 40,
      '#default_value' => $values['field_value'],
      '#required' => TRUE,
    );
    $form['field_value_phrase'] = array(
      '#type' => 'checkbox',
      '#title' => t('Exact phrase'),
      '#default_value' => $values['field_value_phrase'],
    );
    return $form;
  }
}
