<?php
// $Id: FeedsAssistantFilter.inc,v 1.1 2010/03/09 16:54:52 pounard Exp $

/**
 * @file
 * Solace Feeds module filters implementation.
 */

class ComesFromFeedAssistantFilter extends AbstractAssistantFilter
{
  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#getTitle()
   */
  public function getTitle() {
    return "Comes from a feed";
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#getDescription()
   */
  public function getDescription() {
    return "Allows to filter search results by origin feed";
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#isBoostAble()
   */
  public function isBoostAble() {
    return FALSE;
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#_build($context, $values, $query)
   */
  protected function _build(AbstractAssistantContext $context, &$values, SolrQuery $query) {
    if (! empty($values['source'])) {
      $query->fq->add($field = new SolrFieldFilter(_assistant_feeds_index_key(), new SolrTerm($values['source'])));
    }
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#_form($context, $values)
   */
  protected function _form(AbstractAssistantContext $context, &$values = array()) {
    $form = array();
    $form['source'] = array(
      '#type' => 'select',
      '#default_value' => isset($values['source']) ? $values['source'] : NULL,
      '#options' => _assistant_feeds_list(),
      '#required' => TRUE,
    );
    return $form;
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#isFilterQuery()
   */
  public function isFilterQuery() {
    return TRUE;
  }
}
