<?php
// $Id: OgAssistantFilter.inc,v 1.1 2010/03/09 16:54:52 pounard Exp $

/**
 * @file
 * Solace OG module filters implementation.
 */

class OgGroupAudienceAssistantFilter extends AbstractAssistantFilter
{
  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#getTitle()
   */
  public function getTitle() {
    return "Belongs to group";
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#getDescription()
   */
  public function getDescription() {
    return "Allows to filter search by group audience";
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#isBoostAble()
   */
  public function isBoostAble() {
    return FALSE;
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#_build($context, $values, $query)
   */
  protected function _build(AbstractAssistantContext $context, &$values, SolrQuery $query) {
    if (!empty($values['audience'])) {
      $query->fq->add(new SolrFieldFilter(apachesolr_og_gid_key(), new SolrTerm($values['audience'])));
    }
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#_form($context, $values)
   */
  protected function _form(AbstractAssistantContext $context, &$values = array()) {
    $form = array();

    if (isset($values['audience']) && $node = node_load($values['audience'])) {
      $default = $node->nid . ' - ' . filter_xss($node->title);
    }
    // Got this field content without validation process
    else if (preg_match('/^[0-9]+\s+-\s+.*$/', $values['audience'])) {
      $default = $values['audience'];
    }
    else {
      $default = NULL;
    }

    $form['audience'] = array(
      '#type' => 'textfield',
      '#default_value' => $default,
      '#autocomplete_path' => 'assistant/og/autocomplete',
      '#required' => TRUE,
    );

    return $form;
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#validate($context, $values)
   */
  protected function _validate(AbstractAssistantContext $context, &$values) {
    $parts = preg_split('/[\s-]+/', trim($values['audience']), 2);
    if (isset($parts[0]) && is_numeric($parts[0])) {
      $values['audience'] = $parts[0];
    }
    else {
      return array('audience', t("Invalid value"));
    }
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#isFilterQuery()
   */
  public function isFilterQuery() {
    return TRUE;
  }
}
