<?php
// $Id: TaxonomyAssistantFilter.inc,v 1.1 2010/03/09 16:54:52 pounard Exp $

/**
 * @file
 * Solace OG module filters implementation.
 */

class TaxonomyAssistantFilter extends AbstractAssistantFilter
{
  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#getTitle()
   */
  public function getTitle() {
    return "Filters by terms";
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#getDescription()
   */
  public function getDescription() {
    return "Allows to filter search using taxonomy terms";
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#isBoostAble()
   */
  public function isBoostAble() {
    return FALSE;
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#_build($context, $values, $query)
   */
  protected function _build(AbstractAssistantContext $context, &$values, SolrQuery $query) {
    if (!empty($values['tid'])) {
      $collection = new SolrTermCollection();
      $collection->setOperator(SolrOperator::OPERATOR_OR);
      foreach ($values['tid'] as $tid) {
        $collection->add(new SolrTerm($tid));
      }
      $filter = new SolrFieldFilter('tid', $collection);
      $filter->setExclusion(SolrOperator::OPERATOR_REQUIRE);
      $query->fq->add($filter);
    }
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#_form($context, $values)
   */
  protected function _form(AbstractAssistantContext $context, &$values = array()) {
    // $form = array();
    $form = array();

    $options = array(NULL => t('-- None --'));
    foreach (taxonomy_get_vocabularies() as $vid => $voc) {
      $options[$vid] = check_plain($voc->name);
    }

    $form['vid'] = array(
      '#title' => t('Select vocabulary'),
      '#type' => 'select',
      '#options' => $options,
      '#required' => TRUE,
      '#default_value' => (isset($values['vid']) ? $values['vid'] : NULL),
      '#weight' => 0,
    );
    $this->setAhahProperty($form['vid'], 'change');

    if (isset($values['vid'])) {
      $form['tid'] = _taxonomy_term_select(t('Select one or more terms'), 'name', NULL, $values['vid'], NULL, TRUE, NULL);
      $form['tid']['#required'] = TRUE;
      $form['tid']['#weight'] = 10;
    }

    return $form;
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantFilter#isFilterQuery()
   */
  public function isFilterQuery() {
    return TRUE;
  }
}
