<?php
// $Id: AssistantRefContext.inc,v 1.1 2010/03/09 16:56:51 pounard Exp $

/**
 * @file
 * Solace Node Reference custom context implementation.
 */

class AssistantRefContext extends NodeAssistantContext
{
  /**
   * Row from assistant_ref_node table.
   * 
   * @var array
   */
  protected $_settings;

  /**
   * Get row from assistant_ref_node table.
   * 
   * @return object
   *   Row from assistant_ref_node table.
   */
  public function getSettings() {
    if (empty($this->_settings)) {
      throw new AssistantContextException('Missing settings in context, did you use the setContext() method?');
    }
    return $this->_settings;
  }

  /**
   * Get row from assistant_ref_node table.
   * 
   * @param object $settings
   *   Row from assistant_ref_node table.
   */
  public function setSettings(&$settings) {
    if (empty($settings) || !isset($settings->fid) || !isset($settings->field_name) || !isset($settings->nid)) {
      throw new AssistantContextException('Incomplete settings given');
    }
    $this->setNid($settings->nid);
    $this->_settings = $settings;
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantContext#getModule()
   */
  public function getModule() {
    return 'assistant_ref';
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantContext#allowPreview()
   */
  public function allowPreview() {
    return TRUE;
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantContext#allowSave()
   */
  public function allowSave() {
    return TRUE;
  }

  /**
   * (non-PHPdoc)
   * @see AbstractAssistantContext#getFid()
   */
  public function getFid() {
    return $this->_settings->fid; 
  }
}
