<?php
// $Id: assistant_ref_daemoncli.drush.inc,v 1.1 2010/03/09 16:56:51 pounard Exp $

/**
 * @file
 * Solace Node Reference CLI Deamon drush integration. 
 */

/**
 * Implementation of hook_drush_command().
 */
function assistant_ref_daemoncli_drush_command() {
  $items = array();
  
  $items['assistant.daemon.run'] = array(
    'description' => 'Launch daemon for assistant_ref',
    'callback'    => '_assistant_ref_daemoncli_daemonize', 
  );
  $items['assistant.daemon.kill'] = array(
    'description' => 'Kill and cleanup state for daemon',
    'callback'    => '_assistant_ref_daemoncli_kill',
  );
  
  return $items;
}

/**
 * Callback for item 'assistant ref daemonize'
 */
function _assistant_ref_daemoncli_daemonize() {
  if (module_exists('assistant_ref_daemoncli') == FALSE) {
    drush_print(dt("You need to activate the module first"));
    return; 
  }
  
  $daemon_pid = variable_get(ASSISTANT_REF_DAEMONCLI_PID, 0);
  
  if ($daemon_pid) {
    drush_print(dt("Daemon already running"));
    return;
  }
  
  $daemon_path = escapeshellcmd(drupal_get_path('module', 'assistant_ref_daemoncli')."/assistant_ref_daemoncli.php ");
  
  // Lauching process
  shell_exec("php -f {$daemon_path} > /dev/null");
}

function _assistant_ref_daemoncli_kill() {
  $daemon_pid = variable_get(ASSISTANT_REF_DAEMONCLI_PID, 0);
  
  // Check if daemon is running
  if (!$daemon_pid) {
    drush_print(dt("No running daemon"));
    return;
  }
  
  // Check if daemon pid is in memory
  if (_assistant_ref_daemoncli_is_running() == FALSE) {
    drush_print(dt("Daemon is not running, changing memory state"));
    variable_set(ASSISTANT_REF_DAEMONCLI_PID, 0);
    variable_set(ASSISTANT_REF_DAEMONCLI_LAST_EXECUTE, 0);
    return;
  } 
  
  // Sending the SIGTERM signal to daemon
  drush_print(dt("Sending SIGTERM signal to daemon"));
  posix_kill($daemon_pid, SIGTERM);
}
