<?php
// $Id: assistant_ref_daemoncli.php,v 1.1 2010/03/09 16:56:51 pounard Exp $

/**
 * @file
 * Main file for service
 */

global $module_path;
global $stop;

// Getting arguments
$args = $_SERVER['argv'];

// Getting module path
$module_path= dirname($args[0]);

// Stop statement
$stop = FALSE;


// Check if launched in cli mode
if (!isset($_SERVER['REMOTE_ADDR'])) {
  $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
}


if (function_exists("pcntl_fork") !== true) {
  print "[ERROR] You must install first php-process package or equivalent";
  return;
}

// Launching process to daemonize service
$pid = pcntl_fork();

switch ($pid) {
  case -1: // Error
    break;
    
  case 0: // Children
    daemonize();
    break;
    
  default: // Parent
    print "[PHP] Launching daemon [pid {$pid}]\n";
    return;
}

// --------------------------------- Functions --------------------------------
/**
 * 
 * @param $signo
 * @return unknown_type
 */
function sig_handler($signo) {
  global $stop;
  
  switch ($signo) {
    case SIGKILL:
    case SIGTERM:
      require_once './includes/bootstrap.inc';
      drupal_bootstrap(DRUPAL_BOOTSTRAP_FULL);
      watchdog("daemon assistant ref", "SIGTERM... Waiting end for process", array(), WATCHDOG_INFO);
      
      // Changing pid number to check if daemon is running
      variable_set(ASSISTANT_REF_DAEMONCLI_PID, 0);
      variable_set(ASSISTANT_REF_DAEMONCLI_LAST_EXECUTE, 0);
      $stop = TRUE;
      break;
  }
}

/**
 * 
 * @return unknown_type
 */
function daemonize() {
  global $stop;
  $first_time = TRUE;

  // Intercept signals
  declare(ticks = 1);
  pcntl_signal(SIGTERM, "sig_handler");
  
  while (true) {
    $child_pid = pcntl_fork();
    
    switch($child_pid) {
      case -1:
        break;
        
      case 0: // Child process
        require_once './includes/bootstrap.inc';
        drupal_bootstrap(DRUPAL_BOOTSTRAP_FULL);
        module_load_include('inc', 'assistant_ref_daemoncli', 'service_children');
        children_process($first_time);
        exit();
        break;
        
      default: // Parent process
        $first_time = FALSE;
        pcntl_waitpid($child_pid, $status);
        break;
    }
    
    if ($stop === TRUE) {
      print "[Daemon] Demande de sortie du programme\n";
      break;
    }
    
    usleep(500000);
  }
  
  return;
}
