<?php 
/**
 * 
 * @return unknown_type
 */
function children_process($savePid) {
  // Create drupal environment
  children_drupal_environment();
  
  posix_setsid();
  
  if ($savePid == TRUE) {
    variable_set(ASSISTANT_REF_DAEMONCLI_PID, posix_getppid());
    variable_set(ASSISTANT_REF_DAEMONCLI_START, time());
  }
  
  // TODO : Check if element is present in queue assistant
  assistant_ref_queue_dequeue();
  
  // Check if admin asks to kill daemon
  if (variable_get(ASSISTANT_REF_DAEMONCLI_STOP, 0) == 1) {
    if (assistant_debug()) {
      print("[DEBUG] Exit by user interface\n");
    }
    
    // Get parent pid
    $pid = variable_get(ASSISTANT_REF_DAEMONCLI_PID, 0);
    
    if ($pid == 0) {
      watchdog("daemon assistant ref", 'pid daemon not stored', array(), WATCHDOG_ERROR);
      return;
    }
    
    watchdog("daemon assistant ref", 'Stop daemon by user interface', array(), WATCHDOG_INFO);
    variable_set(ASSISTANT_REF_DAEMONCLI_STOP, 0);
    
    // Sending signal to parent
    posix_kill($pid, SIGTERM);
  }
    
  return;
}

/**
 * 
 * @return unknown_type
 */
function children_drupal_environment() {
  global $user;
  
  // Login as given user
  if (module_exists('assistant_ref_daemoncli')) {
    $user = assistant_ref_daemoncli_get_user();
  }
  else {
    // Failsafe option, daemon can run without its module.
    $user = user_load(1);
  }

  if (assistant_debug()) {
    print("[DEBUG] Daemon run using '" . $user->name . "' user\n");
  }

  // No saved session
  session_save_session(FALSE);
}
