<?php

namespace Drupal\association\Entity;

use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Interface for entities that are associated to entity associations.
 */
interface AssociatedEntityInterface extends ContentEntityInterface {

  /**
   * Get the association this entity is associated to.
   *
   * @return \Drupal\Core\Entity\AssociationInterface|null
   *   The association this entity is associated to.
   */
  public function getAssociation(): ?AssociationInterface;

}
