<?php

namespace Drupal\association\Entity\Storage;

use Drupal\Core\Entity\Sql\SqlContentEntityStorageSchema;
use Drupal\Core\Entity\ContentEntityTypeInterface;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Entity handler for association link entity storage schemas.
 */
class AssociationLinkStorageSchema extends SqlContentEntityStorageSchema {

  /**
   * {@inheritdoc}
   */
  protected function processBaseTable(ContentEntityTypeInterface $entity_type, array &$schema) {
    parent::processBaseTable($entity_type, $schema);

    $schema['indexes']['association_link_target'] = [
      'entity_type',
      'target',
    ];

    // Ensure that an entity can only be linked to the same association,
    // only once. Any additional linking attempts should fail.
    $schema['unique keys']['association_link_target'] = [
      'association',
      'entity_type',
      'target',
    ];
  }

  /**
   * {@inheritdoc}
   */
  protected function getSharedTableFieldSchema(FieldStorageDefinitionInterface $storage_definition, $table_name, array $column_mapping) {
    $schema = parent::getSharedTableFieldSchema($storage_definition, $table_name, $column_mapping);
    $name = $storage_definition->getName();

    // The association link target doesn't get normal entity reference indexes.
    // This index will get added with the static::processBaseTable() as it spans
    // a couple interelated association fields.
    if ($name === 'target') {
      unset($schema['indexes']);
    }

    // Ensure required base definitions are not allowed to have NULL values.
    if ($storage_definition instanceof BaseFieldDefinition && $storage_definition->isRequired()) {
      $schema['fields'][$name]['not null'] = TRUE;
    }

    return $schema;
  }

}
