<?php

namespace Drupal\association\Plugin\views\argument;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\views\Plugin\views\argument\NumericArgument;

/**
 * Argument handler to accept association entity IDs.
 *
 * @ViewsArgument("association_id")
 */
class AssociationArgument extends NumericArgument {

  /**
   * The storage handler.
   *
   * @var \Drupal\Core\Entity\ContentEntityStorageInterface
   */
  protected $assocStorage;

  /**
   * Constructs the views AssociationArgument object.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, EntityTypeManagerInterface $entity_type_manager) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);

    $this->assocStorage = $entity_type_manager->getStorage('association');
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('entity_type.manager')
    );
  }

  /**
   * Override the behavior of title(). Get the title of the association.
   */
  public function titleQuery() {
    $titles = [];

    foreach ($this->assocStorage->loadMultiple($this->value) as $assoc) {
      $titles[] = $assoc->label();
    }

    return $titles;
  }

}
