# Introduction
Entity association module provides an entity for associating other entities
together into groups of content which are governed by the entity association
behaviors. The controlling association rules are facilitated by behavior plugins,
which can provide enforce the number and types of entities that can be part of
the association.

Content in the association can share banners, menus and other common components.


# Requirements
This module requires the following module:

 * Token - https://www.drupal.org/project/token
 * Toolshed - https://www.drupal.org/project/toolshed


# Installation
Install as you would normally install a contributed Drupal module. Visit
https://www.drupal.org/node/1897420 for further information.


# Extending
Entity Association module strives to be extendable and customizable. The
following are plugins, tagged services, and events which allow additional
entity types, association rules and policies, and management of content to be
added.


## Adding behavior plugins
Behavior plugins are the plugins which manage how entities are added to and
managed by associations. These plugins implement
`\Drupal\association\Plugin\BehaviorInterface` and are placed in the
`/plugin/Association/Behavior` folder.

*See \Drupal\association\Plugin\Association\Behavior\EntityListBehavior*
*See \Drupal\association\Plugin\Association\Behavior\EntityManifestBehavior*


## Adding entity adapters
Entity types become available via entity adapter plugins. Adapters will
determine which entity bundles can be used, build entity operation forms and
association access controls.

Adapters are added by adding a "<module>.association.entity_adapter.yml" file
to your module with entity adapter definitions.

```
# Add support for node entity types to entity associations.
node:
  label: Content (node)
  entity_type: node
  class: \Drupal\association\Adapter\EntityAdapter
```

If class is ommitted the default `\Drupal\association\Adapter\EntityAdapter` is
used. The default *EntityAdapter* class should work for most classes.

*See \Drupal\assocation\Adapter\EntityAdapterInterface*
*See \Drupal\assocation\Adapter\EntityAdapter*


## Adding entity updaters
Entity updaters are command objects which implement
\Drupal\association\EntityUpdater\EntityUpdaterInterface and are run on
associated content when entity associations are updated. This allows
associations to maintain properties and policies for all the content that
belongs to an association.

New entity updaters can be registered from an event subscriber for the
`\Drupal\association\Event\AssociationEvents::ENTITY_UPDATER_ALTER` event.

*see \Drupal\association\Event\AssociationEvents*
*see \Drupal\association\EntityUpdater\AssociatedEntityUpdaterAlterEvent*
*see \Drupal\association\EntityUpdater\EntityUpdaterInterface*
*see \Drupal\association\EntityUpdater\PathAliasUpdater for an example*


## Adding association negotiators
Association negotiators are a tagged service which implement the
`\Drupal\association\AssociationNegotiatorInterface` and register as a service
the tag "association_negotiator".

These negotiators are used to determine the active association for contexts,
routes and from associated content entities. Implement a negotiator when you
want to add custom logic for determining the current association.

*See \Drupal\association\DefaultAssociatonNegotiator for an example.*


# Roadmap
  * EntityListManager using views and pagination
  * Association heirarchy and nesting support
  * Group module support
