<?php

namespace Drupal\association\Entity\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Entity form for creating an association entity.
 */
class AssociationForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);

    $form['advanced'] = [
      '#type' => 'vertical_tabs',
      '#weight' => 50,
    ];

    $form['author'] = [
      '#type' => 'details',
      '#title' => $this->t('Authoring Information'),
      '#group' => 'advanced',
      '#optional' => TRUE,
      '#access' => $form['uid']['#access'] ?? NULL,
    ];

    $form['uid']['#group'] = 'author';
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $status = parent::save($form, $form_state);

    $entity = $this->entity;
    $msgParams = [
      '%label' => $entity->label(),
      ':bundle' => $entity->getType()->label(),
    ];

    $msg = SAVED_NEW === $status
      ? $this->t('Created the %label :bundle.', $msgParams)
      : $this->t('Saved the %label :bundle.', $msgParams);

    $this->messenger()->addStatus($msg);
    $form_state->setRedirectUrl($entity->toUrl('manage'));

    return $status;
  }

}
