<?php

namespace Drupal\association\Entity\Storage;

use Drupal\Core\Entity\Sql\SqlContentEntityStorage;
use Drupal\Core\Entity\EntityInterface;

/**
 * Defines the storage handler class for association entities.
 *
 * This extends the base storage class, adding the ability to generate the
 * complementary association pages when the type dictates that it has pages.
 *
 * @ingroup association
 */
class AssociationStorage extends SqlContentEntityStorage {

  /**
   * {@inheritdoc}
   */
  protected function doSave($id, EntityInterface $entity) {
    /** @var \Drupal\association\Entity\AssociationInterface $entity */
    $isNew = $entity->isNew();

    parent::doSave($id, $entity);

    // For association types which have complementary pages, create those
    // pages directly after saving the association itself.
    $type = $entity->getType();
    if ($isNew && $type && $type->hasPage()) {
      $page = $this->entityTypeManager
        ->getStorage('association_page')
        ->create([
          'id' => $entity->id(),
          'title' => $entity->label(),
          'type' => $type->id(),
        ]);

      $page->save();
    }
  }

}
