<?php

namespace Drupal\association_menu\Plugin\Toolshed\ThirdPartyConfig;

use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\toolshed\Plugin\ThirdPartyConfigBase;

/**
 * Creates third party configuration for entity association menus.
 *
 * @ToolshedThirdPartyConfig(
 *   id = "association_menu",
 *   label = @Translation("Menu settings"),
 *   entity_types = {
 *     "association_type",
 *   },
 * )
 */
class AssociationMenuThirdPartyConfig extends ThirdPartyConfigBase {

  /**
   * {@inheritdoc}
   */
  public function getDefaultSettings(): array {
    return [
      'menu_nesting' => FALSE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  protected function formElements(ConfigEntityInterface $entity, array $settings, FormStateInterface $form_state): array {
    $elements['menu_nesting'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Allow nesting for association menu items'),
      '#default_value' => $settings['menu_nesting'],
    ];

    return $elements;
  }

}
