<?php

namespace Drupal\association\Entity;

use Drupal\association\Plugin\BehaviorInterface;
use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Interface for association entity type (bundle) classes.
 */
interface AssociationTypeInterface extends ConfigEntityInterface {

  /**
   * Does this behavior type support a dedicated display page.
   *
   * @return bool
   *   Does this behavior type have a dedicated display page.
   */
  public function hasPage();

  /**
   * Check if this bundle has content data.
   *
   * New config entities cannot have any content created for them yet, so will
   * always return FALSE.
   *
   * @return bool
   *   TRUE if there is content using the type as a bundle, or FALSE is there
   *   is no data of this type.
   */
  public function hasData();

  /**
   * Indicates if content for associations of this type should be searchable.
   *
   * This method currently works with the search_api module indexes.
   *
   * @return bool
   *   TRUE if content should be included in search index, and FALSE otherwise.
   */
  public function isContentSearchable(): bool;

  /**
   * Get the plugin behavior for this association type.
   *
   * @param bool $force_rebuild
   *   Force the rebuilding of the behavior plugin, even if it was already
   *   instantiated.
   *
   * @return \Drupal\association\Plugin\BehaviorInterface|null
   *   Get the plugin to control the behavior of the associations of this type.
   *   Should always return a behavior, unless data has been corrupted.
   */
  public function getBehavior($force_rebuild = FALSE): ?BehaviorInterface;

  /**
   * Validation potential configuration changes to ensure safe updates.
   *
   * There are several settings that are important to an association and cannot
   * be safely updated if this association type already has data.
   *
   * @param array $updates
   *   The perspective configuration to validate as options that can update.
   *
   * @return string[]
   *   An array of reported configuration errors if there were any. Returns an
   *   empty array if there were no errors to report.
   */
  public function validateConfigChanges(array $updates);

}
