<?php

namespace Drupal\association\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin attribute for association landing page handler plugins.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class AssociationLandingPage extends Plugin {

  /**
   * Creates a new instance of the AssociationBehavior attribute.
   *
   * @param string $id
   *   The plugin machine name identifier.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   The plugin label.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   Provide a description for the landing page plugin and helpful tips for
   *   aiding with the plugin selection.
   * @param class-string|null $deriver
   *   The plugin deriver fully namespaced class.
   * @param string $form_handler
   *   The plugin form class to build the configuration form elements.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $label = NULL,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly ?string $deriver = NULL,
    public readonly ?string $form_handler = NULL,
  ) {}

}
