<?php

namespace Drupal\association_autogen\Utility;

use Drupal\association\Entity\AssociationInterface;
use Drupal\Core\Entity\EntityInterface;

/**
 * Base interface for the association entity generator service.
 */
interface EntityGeneratorInterface {

  /**
   * Generate multiple entities for an association from the auto-gen settings.
   *
   * @param \Drupal\association\Entity\AssociationInterface $association
   *   The association to generate entities for.
   * @param array $autogenConfig
   *   An array with the auto-generation config for building entities.
   * @param bool $saveEntity
   *   Should entities all be saved after they are built?
   *
   * @return \Drupal\Core\Entity\EntityInterface[]
   *   An array with all the generated entities.
   */
  public function generateMultiple(AssociationInterface $association, array $autogenConfig, bool $saveEntity = TRUE): array;

  /**
   * Create a single entity for an association from auto-generation config.
   *
   * @param \Drupal\association\Entity\AssociationInterface $association
   *   The association to generate the entity for.
   * @param array $autogenerate
   *   The entity type, bundle and association tag of the entity to generate.
   * @param bool $saveEntity
   *   Should the generated entity be saved?
   *
   * @return \Drupal\Core\Entity\EntityInterface|null
   *   The generated entity, or NULL if the entity could not be created.
   */
  public function generate(AssociationInterface $association, array $autogenerate, bool $saveEntity = TRUE): ?EntityInterface;

}
