/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.drupal.project.async_command.DrupalRuntimeException;
import org.drupal.project.async_command.EvaluationFailureException;
import org.drupal.project.async_command.Result;
import org.lorecraft.phparser.SerializedPhpParser;

public abstract class AbstractDrupalApp {
    protected DataSource dataSource;
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    protected Properties config = new Properties();
    protected String configFilePath = this.getDefaultConfigFilePath();
    protected RunningMode runningMode = RunningMode.ONCE;
    protected String dbPrefix;

    public abstract String identifier();

    public void runApp() {
        this.initDrupalConnection();
        this.prepareApp();
        List<Map<String, Object>> commandList = null;
        try {
            commandList = this.query("SELECT id, command, uid, eid, created FROM {async_command} WHERE app=? AND status IS NULL ORDER BY created", this.identifier());
        }
        catch (SQLException e) {
            this.logger.severe("Cannot query async_command table.");
            throw new DrupalRuntimeException(e);
        }
        this.logger.info("Total commands to be executed: " + commandList.size());
        for (Map<String, Object> commandRecord : commandList) {
            int id = ((Long)commandRecord.get("id")).intValue();
            String command = (String)commandRecord.get("command");
            this.prepareCommand((Integer)commandRecord.get("uid"), (Integer)commandRecord.get("eid"), (Integer)commandRecord.get("created"));
            this.logger.info("Running async_command: " + command);
            Result result = null;
            try {
                result = this.runCommand(command);
            }
            catch (EvaluationFailureException e) {
                this.updateRecord(id, false, "Command evaluation error. See script log for details. Error: " + e.getMessage());
                e.printStackTrace();
                continue;
            }
            this.updateRecord(id, result.getStatus(), result.getMessage());
            this.logger.info("Result: " + result.getStatus());
        }
    }

    protected void prepareApp() {
    }

    protected Result runCommand(String command) throws EvaluationFailureException {
        try {
            Interpreter interpreter = new Interpreter();
            interpreter.set("app", (Object)this);
            Result result = (Result)interpreter.eval("app." + command);
            return result;
        }
        catch (EvalError e) {
            this.logger.severe("Cannot execute the command: " + command);
            throw new EvaluationFailureException(e);
        }
        catch (ClassCastException e) {
            this.logger.severe("The command should return a Result object.");
            throw new EvaluationFailureException(e);
        }
    }

    protected void prepareCommand(int uid, int eid, int created) {
    }

    protected void updateRecord(int id, boolean status, String message) {
        long changed = new Date().getTime() / 1000L;
        try {
            this.update("UPDATE {async_command} SET status=?, message=?, changed=? WHERE id=?", status, message, changed, id);
        }
        catch (SQLException e) {
            this.logger.severe("Cannot update status in async_command.");
            throw new DrupalRuntimeException(e);
        }
    }

    protected void initDrupalConnection() {
        assert (this.dataSource == null);
        try {
            String p;
            File configFile = new File(this.configFilePath);
            if (!configFile.exists()) {
                throw new DrupalRuntimeException("Database configuration file " + this.configFilePath + " doesn't exists.");
            }
            FileReader configReader = new FileReader(configFile);
            this.config.load(configReader);
            if (this.config.containsKey("prefix") && (p = this.config.getProperty("prefix").trim()).length() != 0) {
                this.dbPrefix = p;
            }
            this.dataSource = BasicDataSourceFactory.createDataSource((Properties)this.config);
        }
        catch (IOException e) {
            this.logger.severe("Error reading configuration file.");
            throw new DrupalRuntimeException(e);
        }
        catch (Exception e) {
            this.logger.severe("Error initializing DataSource for Drupal database connection.");
            throw new DrupalRuntimeException(e);
        }
    }

    public void testConnection() {
        this.initDrupalConnection();
        try {
            Connection conn = this.dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            this.logger.info("Database connection successful: " + metaData.getDatabaseProductName() + metaData.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            this.logger.severe("SQL error during testing connection.");
            throw new DrupalRuntimeException(e);
        }
    }

    protected String getDefaultConfigFilePath() {
        String workingDir = System.getProperty("user.dir");
        return workingDir + File.separator + "config.properties";
    }

    protected String d(String sql) {
        String newSql = this.dbPrefix != null ? sql.replaceAll("\\{(.+?)\\}", this.dbPrefix + "_" + "$1") : sql.replaceAll("\\{(.+?)\\}", "$1");
        return newSql;
    }

    protected List<Map<String, Object>> query(String sql, Object ... params) throws SQLException {
        QueryRunner q = new QueryRunner(this.dataSource);
        List result = (List)q.query(this.d(sql), (ResultSetHandler)new MapListHandler(), params);
        return result;
    }

    protected Object queryValue(String sql, Object ... params) throws SQLException {
        QueryRunner q = new QueryRunner(this.dataSource);
        Object result = q.query(this.d(sql), (ResultSetHandler)new ScalarHandler(), params);
        return result;
    }

    protected int update(String sql, Object ... params) throws SQLException {
        QueryRunner q = new QueryRunner(this.dataSource);
        int num = q.update(this.d(sql), params);
        return num;
    }

    public void handleCLI(String[] args) {
        Options options = this.buildOptions();
        PosixParser parser = new PosixParser();
        CommandLine command = null;
        try {
            command = parser.parse(options, args);
        }
        catch (ParseException exp) {
            this.logger.severe("Cannot parse parameters. Please use -h to see help. Error message: " + exp.getMessage());
            return;
        }
        this.handleCommandSettings(command);
        this.handleCommandExecutables(command);
    }

    protected void handleCommandExecutables(CommandLine command) {
        if (command.hasOption('h')) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Drupal application -- " + this.identifier(), this.buildOptions());
        } else if (command.hasOption('t')) {
            this.testConnection();
        } else if (command.hasOption('e')) {
            this.initDrupalConnection();
            String evalStr = command.getOptionValue('e');
            try {
                Result result = this.runCommand(evalStr);
                String successMsg = result.getStatus() ? "succeeds" : "fails";
                this.logger.info("Running " + successMsg + ". Message: " + result.getMessage());
            }
            catch (EvaluationFailureException e) {
                this.logger.severe("Cannot evaluate script from command line.");
                throw new DrupalRuntimeException(e);
            }
        } else {
            this.runApp();
        }
    }

    protected void handleCommandSettings(CommandLine command) {
        if (command.hasOption('c')) {
            this.configFilePath = command.getOptionValue('c');
            this.logger.info("Set configuration file as: " + this.configFilePath);
        }
        if (command.hasOption('r')) {
            String rm = command.getOptionValue('r');
            if (rm.equals("once")) {
                this.runningMode = RunningMode.ONCE;
            } else {
                if (rm.equals("continuous")) {
                    throw new UnsupportedOperationException();
                }
                if (rm.equals("listening")) {
                    throw new UnsupportedOperationException();
                }
                this.logger.severe("Cannot parse parameters for -r. Please use -h to see help. Use default running mode.");
            }
        }
    }

    protected Options buildOptions() {
        Options options = new Options();
        options.addOption("c", true, "database configuration file");
        options.addOption("r", true, "program running mode: 'once' (default), 'continuous', or 'listening'");
        options.addOption("h", "help", false, "print this message");
        options.addOption("t", "test", false, "test connection to Drupal database");
        options.addOption("e", "eval", true, "evaluate a method call directly");
        return options;
    }

    public void run(String[] args) {
        this.handleCLI(args);
    }

    protected Properties readEncryptedSettingsField(String value, EncryptionMethod encryptionMethod) {
        String origValue = null;
        switch (encryptionMethod) {
            case NONE: {
                origValue = value;
                break;
            }
            case BASE64: {
                origValue = new String(Base64.decodeBase64((String)value));
                break;
            }
            case MCRYPT: {
                if (!this.config.containsKey("mcrypt_secret_key")) {
                    throw new DrupalRuntimeException("Need mcrypt_secret_key in the config file in order to decrypt.");
                }
                String secretKey = this.config.getProperty("mcrypt_secret_key");
                origValue = this.evalPhp("echo rtrim(mcrypt_decrypt(MCRYPT_3DES,''{0}'',base64_decode(''{1}''),''ecb''),''\\0'');", secretKey, value);
                origValue = origValue.trim();
            }
        }
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(origValue));
        }
        catch (IOException e) {
            this.logger.severe("Cannot read encrypted settings field.");
            throw new DrupalRuntimeException(e);
        }
        return properties;
    }

    protected String evalPhp(String pattern, Object ... params) {
        assert (pattern != null && !pattern.isEmpty());
        String phpCode = MessageFormat.format(pattern, params);
        return this.evalPhp(phpCode);
    }

    protected String evalPhp(String phpCode) {
        String phpCli = this.config.getProperty("php_cli", "php");
        String[] cmd = new String[]{phpCli, "-r", phpCode};
        try {
            int c;
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
            if (process.exitValue() != 0) {
                this.logger.severe("PHP process exception.");
                throw new DrupalRuntimeException("Unexpected PHP error: " + process.exitValue());
            }
            StringBuilder sb = new StringBuilder();
            InputStreamReader input = new InputStreamReader(process.getInputStream());
            while ((c = ((Reader)input).read()) != -1) {
                sb.append((char)c);
            }
            return sb.toString();
        }
        catch (IOException e) {
            this.logger.severe("Cannot run PHP code. Possible reasons: missing PHP CLI executable or dependent libraries.");
            throw new DrupalRuntimeException(e);
        }
        catch (InterruptedException e) {
            this.logger.severe("PHP code interrupted.");
            throw new DrupalRuntimeException(e);
        }
    }

    protected String convertBlobValueToString(Object blobValue) {
        byte[] blobBytes = (byte[])blobValue;
        return new String(blobBytes);
    }

    protected Object drupalVariableGet(String varName) {
        try {
            Object serializedBytes = this.queryValue("SELECT value FROM {variable} WHERE name=?", varName);
            String serialized = this.convertBlobValueToString(serializedBytes);
            SerializedPhpParser serializedPhpParser = new SerializedPhpParser(serialized);
            return serializedPhpParser.parse();
        }
        catch (SQLException e) {
            throw new DrupalRuntimeException(e);
        }
        catch (ClassCastException e) {
            throw new DrupalRuntimeException(e);
        }
    }

    protected void drupalVariableSet(String varName, String varValue) {
        String serialized = this.evalPhp("echo serialize(''{0}'');", varValue);
        byte[] serializedBytes = serialized.getBytes();
        try {
            this.update("UPDATE {variable} SET value=? WHERE name=?", serializedBytes, varName);
        }
        catch (SQLException e) {
            throw new DrupalRuntimeException(e);
        }
    }

    public static enum EncryptionMethod {
        NONE,
        BASE64,
        MCRYPT;

    }

    public static enum RunningMode {
        ONCE,
        CONTINUOUS,
        LISTENING;

    }
}

