/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command;

import java.util.Properties;
import org.drupal.project.async_command.AbstractDrupalApp;
import org.drupal.project.async_command.DefaultDrupalApp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultDrupalAppTest {
    DefaultDrupalApp app;

    @Before
    public void setUp() throws Exception {
        this.app = new DefaultDrupalApp();
        this.app.initDrupalConnection();
    }

    public void testBasic() throws Exception {
        this.app.testConnection();
        this.app.config.list(System.out);
    }

    @Test
    public void testIdentifier() throws Exception {
        Assert.assertTrue((boolean)this.app.identifier().equals("default"));
    }

    @Test
    public void testEvalPhp() throws Exception {
        String str = "Hello, world";
        Assert.assertTrue((boolean)this.app.evalPhp("echo \"{0}\";", str).equals(str));
        Assert.assertTrue((boolean)this.app.evalPhp("echo 1;").equals("1"));
        this.app.config.put("php_cli", "/usr/bin/php");
        Assert.assertTrue((boolean)this.app.evalPhp("echo \"{0}\";", str).equals(str));
        this.app.config.remove("php_cli");
    }

    public void testEvalPhpFail() throws Exception {
        this.app.config.put("php_cli", "/usr/bin/phpx");
        Assert.assertTrue((boolean)this.app.evalPhp("echo 1;").equals("1"));
        this.app.config.remove("php_cli");
    }

    @Test
    public void testDecryption() throws Exception {
        String orig = "abc=def";
        String key = this.app.config.getProperty("mcrypt_secret_key");
        Assert.assertNotNull((Object)key);
        String enc = this.app.evalPhp("echo base64_encode(mcrypt_encrypt(MCRYPT_3DES, \"{0}\", \"{1}\", 'ecb'));", key, orig);
        Properties p = this.app.readEncryptedSettingsField(enc, AbstractDrupalApp.EncryptionMethod.MCRYPT);
        Assert.assertTrue((boolean)p.getProperty("abc").trim().equals("def"));
    }

    @Test
    public void testDrupalVariable() throws Exception {
        Object value = this.app.drupalVariableGet("anonymous");
        Assert.assertTrue((value.getClass() == String.class ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)value).equals("Anonymous"));
        String siteName = (String)this.app.drupalVariableGet("site_name");
        String testSiteName = "site name in test";
        this.app.drupalVariableSet("site_name", testSiteName);
        Assert.assertTrue((boolean)((String)this.app.drupalVariableGet("site_name")).equals(testSiteName));
        this.app.drupalVariableSet("site_name", siteName);
    }

    @Test
    public void testDbUtils() throws Exception {
        long uid = (Long)this.app.queryValue("SELECT uid FROM {users} WHERE uid=1", new Object[0]);
        Assert.assertTrue((uid == 1L ? 1 : 0) != 0);
        Object result = this.app.queryValue("SELECT uid FROM {users} WHERE uid=-1", new Object[0]);
        Assert.assertNull((Object)result);
    }
}

