/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ExceptionInterceptor;
import com.mysql.jdbc.Extension;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.StringUtils;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class Util {
    protected static Method systemNanoTimeMethod;
    private static Method CAST_METHOD;
    private static final TimeZone DEFAULT_TIMEZONE;
    private static Util enclosingInstance;
    private static boolean isJdbc4;
    private static boolean isColdFusion;

    static {
        try {
            systemNanoTimeMethod = System.class.getMethod("nanoTime", null);
        }
        catch (SecurityException securityException) {
            systemNanoTimeMethod = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            systemNanoTimeMethod = null;
        }
        DEFAULT_TIMEZONE = TimeZone.getDefault();
        enclosingInstance = new Util();
        isJdbc4 = false;
        isColdFusion = false;
        try {
            CAST_METHOD = Class.class.getMethod("cast", Object.class);
        }
        catch (Throwable throwable) {}
        try {
            Class.forName("java.sql.NClob");
            isJdbc4 = true;
        }
        catch (Throwable throwable) {
            isJdbc4 = false;
        }
        String loadedFrom = Util.stackTraceToString(new Throwable());
        isColdFusion = loadedFrom != null ? loadedFrom.indexOf("coldfusion") != -1 : false;
    }

    public static boolean nanoTimeAvailable() {
        return systemNanoTimeMethod != null;
    }

    static final TimeZone getDefaultTimeZone() {
        return (TimeZone)DEFAULT_TIMEZONE.clone();
    }

    public static boolean isJdbc4() {
        return isJdbc4;
    }

    public static boolean isColdFusion() {
        return isColdFusion;
    }

    static String newCrypt(String password, String seed) {
        byte b;
        double d;
        if (password == null || password.length() == 0) {
            return password;
        }
        long[] pw = Util.newHash(seed);
        long[] msg = Util.newHash(password);
        long max = 0x3FFFFFFFL;
        long seed1 = (pw[0] ^ msg[0]) % max;
        long seed2 = (pw[1] ^ msg[1]) % max;
        char[] chars = new char[seed.length()];
        int i = 0;
        while (i < seed.length()) {
            seed1 = (seed1 * 3L + seed2) % max;
            seed2 = (seed1 + seed2 + 33L) % max;
            d = (double)seed1 / (double)max;
            b = (byte)Math.floor(d * 31.0 + 64.0);
            chars[i] = (char)b;
            ++i;
        }
        seed1 = (seed1 * 3L + seed2) % max;
        seed2 = (seed1 + seed2 + 33L) % max;
        d = (double)seed1 / (double)max;
        b = (byte)Math.floor(d * 31.0);
        i = 0;
        while (i < seed.length()) {
            int n = i++;
            chars[n] = (char)(chars[n] ^ (char)b);
        }
        return new String(chars);
    }

    static long[] newHash(String password) {
        long nr = 1345345333L;
        long add = 7L;
        long nr2 = 305419889L;
        int i = 0;
        while (i < password.length()) {
            if (password.charAt(i) != ' ' && password.charAt(i) != '\t') {
                long tmp = 0xFF & password.charAt(i);
                nr ^= ((nr & 0x3FL) + add) * tmp + (nr << 8);
                nr2 += nr2 << 8 ^ nr;
                add += tmp;
            }
            ++i;
        }
        long[] result = new long[]{nr & Integer.MAX_VALUE, nr2 & Integer.MAX_VALUE};
        return result;
    }

    static String oldCrypt(String password, String seed) {
        long max = 0x1FFFFFFL;
        if (password == null || password.length() == 0) {
            return password;
        }
        long hp = Util.oldHash(seed);
        long hm = Util.oldHash(password);
        long nr = hp ^ hm;
        long s1 = nr %= max;
        long s2 = nr / 2L;
        char[] chars = new char[seed.length()];
        int i = 0;
        while (i < seed.length()) {
            s1 = (s1 * 3L + s2) % max;
            s2 = (s1 + s2 + 33L) % max;
            double d = (double)s1 / (double)max;
            byte b = (byte)Math.floor(d * 31.0 + 64.0);
            chars[i] = (char)b;
            ++i;
        }
        return new String(chars);
    }

    static long oldHash(String password) {
        long nr = 1345345333L;
        long nr2 = 7L;
        int i = 0;
        while (i < password.length()) {
            if (password.charAt(i) != ' ' && password.charAt(i) != '\t') {
                long tmp = password.charAt(i);
                nr ^= ((nr & 0x3FL) + nr2) * tmp + (nr << 8);
                nr2 += tmp;
            }
            ++i;
        }
        return nr & Integer.MAX_VALUE;
    }

    private static RandStructcture randomInit(long seed1, long seed2) {
        RandStructcture randStruct = enclosingInstance.new RandStructcture();
        randStruct.maxValue = 0x3FFFFFFFL;
        randStruct.maxValueDbl = randStruct.maxValue;
        randStruct.seed1 = seed1 % randStruct.maxValue;
        randStruct.seed2 = seed2 % randStruct.maxValue;
        return randStruct;
    }

    public static Object readObject(ResultSet resultSet, int index) throws Exception {
        ObjectInputStream objIn = new ObjectInputStream(resultSet.getBinaryStream(index));
        Object obj = objIn.readObject();
        objIn.close();
        return obj;
    }

    private static double rnd(RandStructcture randStruct) {
        randStruct.seed1 = (randStruct.seed1 * 3L + randStruct.seed2) % randStruct.maxValue;
        randStruct.seed2 = (randStruct.seed1 + randStruct.seed2 + 33L) % randStruct.maxValue;
        return (double)randStruct.seed1 / randStruct.maxValueDbl;
    }

    public static String scramble(String message, String password) {
        byte[] to = new byte[8];
        String val = "";
        message = message.substring(0, 8);
        if (password != null && password.length() > 0) {
            long[] hashPass = Util.newHash(password);
            long[] hashMessage = Util.newHash(message);
            RandStructcture randStruct = Util.randomInit(hashPass[0] ^ hashMessage[0], hashPass[1] ^ hashMessage[1]);
            int msgPos = 0;
            int msgLength = message.length();
            int toPos = 0;
            while (msgPos++ < msgLength) {
                to[toPos++] = (byte)(Math.floor(Util.rnd(randStruct) * 31.0) + 64.0);
            }
            byte extra = (byte)Math.floor(Util.rnd(randStruct) * 31.0);
            int i = 0;
            while (i < to.length) {
                int n = i++;
                to[n] = (byte)(to[n] ^ extra);
            }
            val = new String(to);
        }
        return val;
    }

    public static String stackTraceToString(Throwable ex) {
        StringBuffer traceBuf = new StringBuffer();
        traceBuf.append(Messages.getString("Util.1"));
        if (ex != null) {
            traceBuf.append(ex.getClass().getName());
            String message = ex.getMessage();
            if (message != null) {
                traceBuf.append(Messages.getString("Util.2"));
                traceBuf.append(message);
            }
            StringWriter out = new StringWriter();
            PrintWriter printOut = new PrintWriter(out);
            ex.printStackTrace(printOut);
            traceBuf.append(Messages.getString("Util.3"));
            traceBuf.append(out.toString());
        }
        traceBuf.append(Messages.getString("Util.4"));
        return traceBuf.toString();
    }

    public static Object getInstance(String className, Class[] argTypes, Object[] args, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        try {
            return Util.handleNewInstance(Class.forName(className).getConstructor(argTypes), args, exceptionInterceptor);
        }
        catch (SecurityException e) {
            throw SQLError.createSQLException("Can't instantiate required class", "S1000", e, exceptionInterceptor);
        }
        catch (NoSuchMethodException e) {
            throw SQLError.createSQLException("Can't instantiate required class", "S1000", e, exceptionInterceptor);
        }
        catch (ClassNotFoundException e) {
            throw SQLError.createSQLException("Can't instantiate required class", "S1000", e, exceptionInterceptor);
        }
    }

    public static final Object handleNewInstance(Constructor ctor, Object[] args, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        try {
            return ctor.newInstance(args);
        }
        catch (IllegalArgumentException e) {
            throw SQLError.createSQLException("Can't instantiate required class", "S1000", e, exceptionInterceptor);
        }
        catch (InstantiationException e) {
            throw SQLError.createSQLException("Can't instantiate required class", "S1000", e, exceptionInterceptor);
        }
        catch (IllegalAccessException e) {
            throw SQLError.createSQLException("Can't instantiate required class", "S1000", e, exceptionInterceptor);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof SQLException) {
                throw (SQLException)target;
            }
            if (target instanceof ExceptionInInitializerError) {
                target = ((ExceptionInInitializerError)target).getException();
            }
            throw SQLError.createSQLException(target.toString(), "S1000", exceptionInterceptor);
        }
    }

    public static boolean interfaceExists(String hostname) {
        try {
            Class<?> networkInterfaceClass = Class.forName("java.net.NetworkInterface");
            return networkInterfaceClass.getMethod("getByName", null).invoke(networkInterfaceClass, hostname) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Object cast(Object invokeOn, Object toCast) {
        if (CAST_METHOD != null) {
            try {
                return CAST_METHOD.invoke(invokeOn, toCast);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    public static long getCurrentTimeNanosOrMillis() {
        if (systemNanoTimeMethod != null) {
            try {
                return (Long)systemNanoTimeMethod.invoke(null, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return System.currentTimeMillis();
    }

    public static void resultSetToMap(Map mappedValues, ResultSet rs) throws SQLException {
        while (rs.next()) {
            mappedValues.put(rs.getObject(1), rs.getObject(2));
        }
    }

    public static Map calculateDifferences(Map map1, Map map2) {
        HashMap diffMap = new HashMap();
        for (Map.Entry entry : map1.entrySet()) {
            Object key = entry.getKey();
            Number value1 = null;
            Number value2 = null;
            if (entry.getValue() instanceof Number) {
                value1 = (Number)entry.getValue();
                value2 = (Number)map2.get(key);
            } else {
                try {
                    value1 = new Double(entry.getValue().toString());
                    value2 = new Double(map2.get(key).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            if (value1.equals(value2)) continue;
            if (value1 instanceof Byte) {
                diffMap.put(key, new Byte((byte)((Byte)value2 - (Byte)value1)));
                continue;
            }
            if (value1 instanceof Short) {
                diffMap.put(key, new Short((short)((Short)value2 - (Short)value1)));
                continue;
            }
            if (value1 instanceof Integer) {
                diffMap.put(key, new Integer((Integer)value2 - (Integer)value1));
                continue;
            }
            if (value1 instanceof Long) {
                diffMap.put(key, new Long((Long)value2 - (Long)value1));
                continue;
            }
            if (value1 instanceof Float) {
                diffMap.put(key, new Float(((Float)value2).floatValue() - ((Float)value1).floatValue()));
                continue;
            }
            if (value1 instanceof Double) {
                diffMap.put(key, new Double(((Double)value2).shortValue() - ((Double)value1).shortValue()));
                continue;
            }
            if (value1 instanceof BigDecimal) {
                diffMap.put(key, ((BigDecimal)value2).subtract((BigDecimal)value1));
                continue;
            }
            if (!(value1 instanceof BigInteger)) continue;
            diffMap.put(key, ((BigInteger)value2).subtract((BigInteger)value1));
        }
        return diffMap;
    }

    public static List loadExtensions(Connection conn, Properties props, String extensionClassNames, String errorMessageKey, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        LinkedList<Extension> extensionList = new LinkedList<Extension>();
        List interceptorsToCreate = StringUtils.split(extensionClassNames, ",", true);
        Iterator iter = interceptorsToCreate.iterator();
        String className = null;
        try {
            while (iter.hasNext()) {
                className = iter.next().toString();
                Extension extensionInstance = (Extension)Class.forName(className).newInstance();
                extensionInstance.init(conn, props);
                extensionList.add(extensionInstance);
            }
        }
        catch (Throwable t) {
            SQLException sqlEx = SQLError.createSQLException(Messages.getString(errorMessageKey, new Object[]{className}), exceptionInterceptor);
            sqlEx.initCause(t);
            throw sqlEx;
        }
        return extensionList;
    }

    class RandStructcture {
        long maxValue;
        double maxValueDbl;
        long seed1;
        long seed2;

        RandStructcture() {
        }
    }
}

