/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.ByteArrayRow;
import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.Constants;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.MysqlParameterMetadata;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSetImpl;
import com.mysql.jdbc.ResultSetInternalMethods;
import com.mysql.jdbc.ResultSetMetaData;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.StatementImpl;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import com.mysql.jdbc.Util;
import com.mysql.jdbc.exceptions.MySQLStatementCancelledException;
import com.mysql.jdbc.exceptions.MySQLTimeoutException;
import com.mysql.jdbc.profiler.ProfilerEvent;
import com.mysql.jdbc.profiler.ProfilerEventHandlerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.TimerTask;

public class ServerPreparedStatement
extends PreparedStatement {
    private static final Constructor JDBC_4_SPS_CTOR;
    protected static final int BLOB_STREAM_READ_BUF_SIZE = 8192;
    private static final byte MAX_DATE_REP_LENGTH = 5;
    private static final byte MAX_DATETIME_REP_LENGTH = 12;
    private static final byte MAX_TIME_REP_LENGTH = 13;
    private boolean hasOnDuplicateKeyUpdate = false;
    private boolean detectedLongParameterSwitch = false;
    private int fieldCount;
    private boolean invalid = false;
    private SQLException invalidationException;
    private boolean isSelectQuery;
    private Buffer outByteBuffer;
    private BindValue[] parameterBindings;
    private Field[] parameterFields;
    private Field[] resultFields;
    private boolean sendTypesToServer = false;
    private long serverStatementId;
    private int stringTypeCode = 254;
    private boolean serverNeedsResetBeforeEachExecution;
    protected boolean isCached = false;
    private boolean useAutoSlowLog;
    private Calendar serverTzCalendar;
    private Calendar defaultTzCalendar;
    private boolean hasCheckedRewrite = false;
    private boolean canRewrite = false;
    private int locationOfOnDuplicateKeyUpdate = -2;

    static {
        if (Util.isJdbc4()) {
            try {
                JDBC_4_SPS_CTOR = Class.forName("com.mysql.jdbc.JDBC4ServerPreparedStatement").getConstructor(ConnectionImpl.class, String.class, String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            JDBC_4_SPS_CTOR = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTime(Buffer intoBuf, Time tm) throws SQLException {
        Calendar sessionCalendar;
        intoBuf.ensureCapacity(9);
        intoBuf.writeByte((byte)8);
        intoBuf.writeByte((byte)0);
        intoBuf.writeLong(0L);
        Calendar calendar = sessionCalendar = this.getCalendarInstanceForSessionOrNew();
        synchronized (calendar) {
            java.util.Date oldTime = sessionCalendar.getTime();
            try {
                sessionCalendar.setTime(tm);
                intoBuf.writeByte((byte)sessionCalendar.get(11));
                intoBuf.writeByte((byte)sessionCalendar.get(12));
                intoBuf.writeByte((byte)sessionCalendar.get(13));
            }
            finally {
                sessionCalendar.setTime(oldTime);
            }
        }
    }

    protected static ServerPreparedStatement getInstance(ConnectionImpl conn, String sql, String catalog, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!Util.isJdbc4()) {
            return new ServerPreparedStatement(conn, sql, catalog, resultSetType, resultSetConcurrency);
        }
        try {
            return (ServerPreparedStatement)JDBC_4_SPS_CTOR.newInstance(conn, sql, catalog, Constants.integerValueOf(resultSetType), Constants.integerValueOf(resultSetConcurrency));
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.toString(), "S1000");
        }
        catch (InstantiationException e) {
            throw new SQLException(e.toString(), "S1000");
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e.toString(), "S1000");
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof SQLException) {
                throw (SQLException)target;
            }
            throw new SQLException(target.toString(), "S1000");
        }
    }

    protected ServerPreparedStatement(ConnectionImpl conn, String sql, String catalog, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(conn, catalog);
        this.checkNullOrEmptyQuery(sql);
        this.hasOnDuplicateKeyUpdate = this.containsOnDuplicateKeyInString(sql);
        int startOfStatement = this.findStartOfStatement(sql);
        this.firstCharOfStmt = StringUtils.firstAlphaCharUc(sql, startOfStatement);
        boolean bl = this.isSelectQuery = 'S' == this.firstCharOfStmt;
        this.serverNeedsResetBeforeEachExecution = this.connection.versionMeetsMinimum(5, 0, 0) ? !this.connection.versionMeetsMinimum(5, 0, 3) : !this.connection.versionMeetsMinimum(4, 1, 10);
        this.useAutoSlowLog = this.connection.getAutoSlowLog();
        this.useTrueBoolean = this.connection.versionMeetsMinimum(3, 21, 23);
        this.hasLimitClause = StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1;
        String statementComment = this.connection.getStatementComment();
        this.originalSql = statementComment == null ? sql : "/* " + statementComment + " */ " + sql;
        this.stringTypeCode = this.connection.versionMeetsMinimum(4, 1, 2) ? 253 : 254;
        try {
            this.serverPrepare(sql);
        }
        catch (SQLException sqlEx) {
            this.realClose(false, true);
            throw sqlEx;
        }
        catch (Exception ex) {
            this.realClose(false, true);
            SQLException sqlEx = SQLError.createSQLException(ex.toString(), "S1000", this.getExceptionInterceptor());
            sqlEx.initCause(ex);
            throw sqlEx;
        }
        this.setResultSetType(resultSetType);
        this.setResultSetConcurrency(resultSetConcurrency);
        this.parameterTypes = new int[this.parameterCount];
    }

    public synchronized void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        this.batchedArgs.add(new BatchedBindValues(this.parameterBindings));
    }

    protected String asSql(boolean quoteStreamsAndUnknowns) throws SQLException {
        String string;
        block20: {
            if (this.isClosed) {
                return "statement has been closed, no further internal information available";
            }
            PreparedStatement pStmtForSub = null;
            try {
                pStmtForSub = PreparedStatement.getInstance(this.connection, this.originalSql, this.currentCatalog);
                int numParameters = pStmtForSub.parameterCount;
                int ourNumParameters = this.parameterCount;
                int i = 0;
                while (i < numParameters && i < ourNumParameters) {
                    if (this.parameterBindings[i] != null) {
                        if (this.parameterBindings[i].isNull) {
                            pStmtForSub.setNull(i + 1, 0);
                        } else {
                            BindValue bindValue = this.parameterBindings[i];
                            switch (bindValue.bufferType) {
                                case 1: {
                                    pStmtForSub.setByte(i + 1, bindValue.byteBinding);
                                    break;
                                }
                                case 2: {
                                    pStmtForSub.setShort(i + 1, bindValue.shortBinding);
                                    break;
                                }
                                case 3: {
                                    pStmtForSub.setInt(i + 1, bindValue.intBinding);
                                    break;
                                }
                                case 8: {
                                    pStmtForSub.setLong(i + 1, bindValue.longBinding);
                                    break;
                                }
                                case 4: {
                                    pStmtForSub.setFloat(i + 1, bindValue.floatBinding);
                                    break;
                                }
                                case 5: {
                                    pStmtForSub.setDouble(i + 1, bindValue.doubleBinding);
                                    break;
                                }
                                default: {
                                    pStmtForSub.setObject(i + 1, this.parameterBindings[i].value);
                                }
                            }
                        }
                    }
                    ++i;
                }
                string = pStmtForSub.asSql(quoteStreamsAndUnknowns);
                if (pStmtForSub == null) break block20;
            }
            catch (Throwable throwable) {
                if (pStmtForSub != null) {
                    try {
                        pStmtForSub.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            try {
                pStmtForSub.close();
            }
            catch (SQLException sQLException) {}
        }
        return string;
    }

    protected void checkClosed() throws SQLException {
        if (this.invalid) {
            throw this.invalidationException;
        }
        super.checkClosed();
    }

    public void clearParameters() throws SQLException {
        this.checkClosed();
        this.clearParametersInternal(true);
    }

    private void clearParametersInternal(boolean clearServerParameters) throws SQLException {
        boolean hadLongData = false;
        if (this.parameterBindings != null) {
            int i = 0;
            while (i < this.parameterCount) {
                if (this.parameterBindings[i] != null && this.parameterBindings[i].isLongData) {
                    hadLongData = true;
                }
                this.parameterBindings[i].reset();
                ++i;
            }
        }
        if (clearServerParameters && hadLongData) {
            this.serverResetStatement();
            this.detectedLongParameterSwitch = false;
        }
    }

    protected void setClosed(boolean flag) {
        this.isClosed = flag;
    }

    public synchronized void close() throws SQLException {
        if (this.isCached && !this.isClosed) {
            this.clearParameters();
            this.isClosed = true;
            this.connection.recachePreparedStatement(this);
            return;
        }
        this.realClose(true, true);
    }

    private void dumpCloseForTestcase() {
        StringBuffer buf = new StringBuffer();
        this.connection.generateConnectionCommentBlock(buf);
        buf.append("DEALLOCATE PREPARE debug_stmt_");
        buf.append(this.statementId);
        buf.append(";\n");
        this.connection.dumpTestcaseQuery(buf.toString());
    }

    private void dumpExecuteForTestcase() throws SQLException {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.parameterCount) {
            this.connection.generateConnectionCommentBlock(buf);
            buf.append("SET @debug_stmt_param");
            buf.append(this.statementId);
            buf.append("_");
            buf.append(i);
            buf.append("=");
            if (this.parameterBindings[i].isNull) {
                buf.append("NULL");
            } else {
                buf.append(this.parameterBindings[i].toString(true));
            }
            buf.append(";\n");
            ++i;
        }
        this.connection.generateConnectionCommentBlock(buf);
        buf.append("EXECUTE debug_stmt_");
        buf.append(this.statementId);
        if (this.parameterCount > 0) {
            buf.append(" USING ");
            i = 0;
            while (i < this.parameterCount) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append("@debug_stmt_param");
                buf.append(this.statementId);
                buf.append("_");
                buf.append(i);
                ++i;
            }
        }
        buf.append(";\n");
        this.connection.dumpTestcaseQuery(buf.toString());
    }

    private void dumpPrepareForTestcase() throws SQLException {
        StringBuffer buf = new StringBuffer(this.originalSql.length() + 64);
        this.connection.generateConnectionCommentBlock(buf);
        buf.append("PREPARE debug_stmt_");
        buf.append(this.statementId);
        buf.append(" FROM \"");
        buf.append(this.originalSql);
        buf.append("\";\n");
        this.connection.dumpTestcaseQuery(buf.toString());
    }

    protected int[] executeBatchSerially(int batchTimeout) throws SQLException {
        ConnectionImpl locallyScopedConn = this.connection;
        if (locallyScopedConn == null) {
            this.checkClosed();
        }
        if (locallyScopedConn.isReadOnly()) {
            throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.2")) + Messages.getString("ServerPreparedStatement.3"), "S1009", this.getExceptionInterceptor());
        }
        this.checkClosed();
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            int[] nArray;
            this.clearWarnings();
            BindValue[] oldBindValues = this.parameterBindings;
            try {
                int[] updateCounts = null;
                if (this.batchedArgs != null) {
                    int nbrCommands = this.batchedArgs.size();
                    updateCounts = new int[nbrCommands];
                    if (this.retrieveGeneratedKeys) {
                        this.batchedGeneratedKeys = new ArrayList(nbrCommands);
                    }
                    int i = 0;
                    while (i < nbrCommands) {
                        updateCounts[i] = -3;
                        ++i;
                    }
                    Throwable sqlEx = null;
                    int commandIndex = 0;
                    BindValue[] previousBindValuesForBatch = null;
                    TimerTask timeoutTask = null;
                    try {
                        if (locallyScopedConn.getEnableQueryTimeouts() && batchTimeout != 0 && locallyScopedConn.versionMeetsMinimum(5, 0, 0)) {
                            timeoutTask = new StatementImpl.CancelTask(this, this);
                            ConnectionImpl.getCancelTimer().schedule(timeoutTask, batchTimeout);
                        }
                        commandIndex = 0;
                        while (commandIndex < nbrCommands) {
                            block35: {
                                Object arg = this.batchedArgs.get(commandIndex);
                                if (arg instanceof String) {
                                    updateCounts[commandIndex] = this.executeUpdate((String)arg);
                                } else {
                                    this.parameterBindings = ((BatchedBindValues)arg).batchedParameterValues;
                                    try {
                                        if (previousBindValuesForBatch != null) {
                                            int j = 0;
                                            while (j < this.parameterBindings.length) {
                                                if (this.parameterBindings[j].bufferType != previousBindValuesForBatch[j].bufferType) {
                                                    this.sendTypesToServer = true;
                                                    break;
                                                }
                                                ++j;
                                            }
                                        }
                                        try {
                                            updateCounts[commandIndex] = this.executeUpdate(false, true);
                                        }
                                        finally {
                                            previousBindValuesForBatch = this.parameterBindings;
                                        }
                                        if (!this.retrieveGeneratedKeys) break block35;
                                        ResultSet rs = null;
                                        try {
                                            rs = this.getGeneratedKeysInternal();
                                            while (rs.next()) {
                                                this.batchedGeneratedKeys.add(new ByteArrayRow(new byte[][]{rs.getBytes(1)}, this.getExceptionInterceptor()));
                                            }
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (SQLException ex) {
                                        updateCounts[commandIndex] = -3;
                                        if (this.continueBatchOnError && !(ex instanceof MySQLTimeoutException) && !(ex instanceof MySQLStatementCancelledException) && !this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
                                            sqlEx = ex;
                                        }
                                        int[] newUpdateCounts = new int[commandIndex];
                                        System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                                    }
                                }
                            }
                            ++commandIndex;
                        }
                    }
                    finally {
                        if (timeoutTask != null) {
                            timeoutTask.cancel();
                        }
                        this.resetCancelledState();
                    }
                    if (sqlEx != null) {
                        throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                    }
                }
                nArray = updateCounts != null ? updateCounts : new int[]{};
                this.parameterBindings = oldBindValues;
                this.sendTypesToServer = true;
            }
            catch (Throwable throwable) {
                this.parameterBindings = oldBindValues;
                this.sendTypesToServer = true;
                this.clearBatch();
                throw throwable;
            }
            this.clearBatch();
            return nArray;
        }
    }

    protected ResultSetInternalMethods executeInternal(int maxRowsToRetrieve, Buffer sendPacket, boolean createStreamingResultSet, boolean queryIsSelectOnly, Field[] metadataFromCache, boolean isBatch) throws SQLException {
        ++this.numberOfExecutions;
        try {
            return this.serverExecute(maxRowsToRetrieve, createStreamingResultSet, metadataFromCache);
        }
        catch (SQLException sqlEx) {
            if (this.connection.getEnablePacketDebug()) {
                this.connection.getIO().dumpPacketRingBuffer();
            }
            if (this.connection.getDumpQueriesOnException()) {
                String extractedSql = this.toString();
                StringBuffer messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = ConnectionImpl.appendMessageToException(sqlEx, messageBuf.toString(), this.getExceptionInterceptor());
            }
            throw sqlEx;
        }
        catch (Exception ex) {
            if (this.connection.getEnablePacketDebug()) {
                this.connection.getIO().dumpPacketRingBuffer();
            }
            SQLException sqlEx = SQLError.createSQLException(ex.toString(), "S1000", this.getExceptionInterceptor());
            if (this.connection.getDumpQueriesOnException()) {
                String extractedSql = this.toString();
                StringBuffer messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = ConnectionImpl.appendMessageToException(sqlEx, messageBuf.toString(), this.getExceptionInterceptor());
            }
            sqlEx.initCause(ex);
            throw sqlEx;
        }
    }

    protected Buffer fillSendPacket() throws SQLException {
        return null;
    }

    protected Buffer fillSendPacket(byte[][] batchedParameterStrings, InputStream[] batchedParameterStreams, boolean[] batchedIsStream, int[] batchedStreamLengths) throws SQLException {
        return null;
    }

    protected BindValue getBinding(int parameterIndex, boolean forLongData) throws SQLException {
        this.checkClosed();
        if (this.parameterBindings.length == 0) {
            throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.8"), "S1009", this.getExceptionInterceptor());
        }
        if (--parameterIndex < 0 || parameterIndex >= this.parameterBindings.length) {
            throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.9")) + (parameterIndex + 1) + Messages.getString("ServerPreparedStatement.10") + this.parameterBindings.length, "S1009", this.getExceptionInterceptor());
        }
        if (this.parameterBindings[parameterIndex] == null) {
            this.parameterBindings[parameterIndex] = new BindValue();
        } else if (this.parameterBindings[parameterIndex].isLongData && !forLongData) {
            this.detectedLongParameterSwitch = true;
        }
        this.parameterBindings[parameterIndex].isSet = true;
        this.parameterBindings[parameterIndex].boundBeforeExecutionNum = this.numberOfExecutions;
        return this.parameterBindings[parameterIndex];
    }

    byte[] getBytes(int parameterIndex) throws SQLException {
        BindValue bindValue = this.getBinding(parameterIndex, false);
        if (bindValue.isNull) {
            return null;
        }
        if (bindValue.isLongData) {
            throw SQLError.notImplemented();
        }
        if (this.outByteBuffer == null) {
            this.outByteBuffer = new Buffer(this.connection.getNetBufferLength());
        }
        this.outByteBuffer.clear();
        int originalPosition = this.outByteBuffer.getPosition();
        this.storeBinding(this.outByteBuffer, bindValue, this.connection.getIO());
        int newPosition = this.outByteBuffer.getPosition();
        int length = newPosition - originalPosition;
        byte[] valueAsBytes = new byte[length];
        System.arraycopy(this.outByteBuffer.getByteBuffer(), originalPosition, valueAsBytes, 0, length);
        return valueAsBytes;
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.resultFields == null) {
            return null;
        }
        return new ResultSetMetaData(this.resultFields, this.connection.getUseOldAliasMetadataBehavior(), this.getExceptionInterceptor());
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.parameterMetaData == null) {
            this.parameterMetaData = new MysqlParameterMetadata(this.parameterFields, this.parameterCount, this.getExceptionInterceptor());
        }
        return this.parameterMetaData;
    }

    boolean isNull(int paramIndex) {
        throw new IllegalArgumentException(Messages.getString("ServerPreparedStatement.7"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realClose(boolean calledExplicitly, boolean closeOpenResults) throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.connection != null) {
            if (this.connection.getAutoGenerateTestcaseScript()) {
                this.dumpCloseForTestcase();
            }
            SQLException exceptionDuringClose = null;
            if (calledExplicitly && !this.connection.isClosed()) {
                Object object = this.connection.getMutex();
                synchronized (object) {
                    try {
                        MysqlIO mysql = this.connection.getIO();
                        Buffer packet = mysql.getSharedSendPacket();
                        packet.writeByte((byte)25);
                        packet.writeLong(this.serverStatementId);
                        mysql.sendCommand(25, null, packet, true, null, 0);
                    }
                    catch (SQLException sqlEx) {
                        exceptionDuringClose = sqlEx;
                    }
                }
            }
            super.realClose(calledExplicitly, closeOpenResults);
            this.clearParametersInternal(false);
            this.parameterBindings = null;
            this.parameterFields = null;
            this.resultFields = null;
            if (exceptionDuringClose != null) {
                throw exceptionDuringClose;
            }
        }
    }

    protected void rePrepare() throws SQLException {
        this.invalidationException = null;
        try {
            this.serverPrepare(this.originalSql);
        }
        catch (SQLException sqlEx) {
            this.invalidationException = sqlEx;
        }
        catch (Exception ex) {
            this.invalidationException = SQLError.createSQLException(ex.toString(), "S1000", this.getExceptionInterceptor());
            this.invalidationException.initCause(ex);
        }
        if (this.invalidationException != null) {
            this.invalid = true;
            this.parameterBindings = null;
            this.parameterFields = null;
            this.resultFields = null;
            if (this.results != null) {
                try {
                    this.results.close();
                }
                catch (Exception exception) {}
            }
            if (this.connection != null) {
                if (this.maxRowsChanged) {
                    this.connection.unsetMaxRows(this);
                }
                if (!this.connection.getDontTrackOpenResources()) {
                    this.connection.unregisterStatement(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetInternalMethods serverExecute(int maxRowsToRetrieve, boolean createStreamingResultSet, Field[] metadataFromCache) throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            ResultSetImpl resultSetImpl;
            block46: {
                int i;
                if (this.detectedLongParameterSwitch) {
                    boolean firstFound = false;
                    long boundTimeToCheck = 0L;
                    int i2 = 0;
                    while (i2 < this.parameterCount - 1) {
                        if (this.parameterBindings[i2].isLongData) {
                            if (firstFound && boundTimeToCheck != this.parameterBindings[i2].boundBeforeExecutionNum) {
                                throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.11")) + Messages.getString("ServerPreparedStatement.12"), "S1C00", this.getExceptionInterceptor());
                            }
                            firstFound = true;
                            boundTimeToCheck = this.parameterBindings[i2].boundBeforeExecutionNum;
                        }
                        ++i2;
                    }
                    this.serverResetStatement();
                }
                int i3 = 0;
                while (i3 < this.parameterCount) {
                    if (!this.parameterBindings[i3].isSet) {
                        throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.13")) + (i3 + 1) + Messages.getString("ServerPreparedStatement.14"), "S1009", this.getExceptionInterceptor());
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < this.parameterCount) {
                    if (this.parameterBindings[i3].isLongData) {
                        this.serverLongData(i3, this.parameterBindings[i3]);
                    }
                    ++i3;
                }
                if (this.connection.getAutoGenerateTestcaseScript()) {
                    this.dumpExecuteForTestcase();
                }
                MysqlIO mysql = this.connection.getIO();
                Buffer packet = mysql.getSharedSendPacket();
                packet.clear();
                packet.writeByte((byte)23);
                packet.writeLong(this.serverStatementId);
                if (this.connection.versionMeetsMinimum(4, 1, 2)) {
                    if (this.resultFields != null && this.connection.isCursorFetchEnabled() && this.getResultSetType() == 1003 && this.getResultSetConcurrency() == 1007 && this.getFetchSize() > 0) {
                        packet.writeByte((byte)1);
                    } else {
                        packet.writeByte((byte)0);
                    }
                    packet.writeLong(1L);
                }
                int nullCount = (this.parameterCount + 7) / 8;
                int nullBitsPosition = packet.getPosition();
                int i4 = 0;
                while (i4 < nullCount) {
                    packet.writeByte((byte)0);
                    ++i4;
                }
                byte[] nullBitsBuffer = new byte[nullCount];
                packet.writeByte(this.sendTypesToServer ? (byte)1 : 0);
                if (this.sendTypesToServer) {
                    i = 0;
                    while (i < this.parameterCount) {
                        packet.writeInt(this.parameterBindings[i].bufferType);
                        ++i;
                    }
                }
                i = 0;
                while (i < this.parameterCount) {
                    if (!this.parameterBindings[i].isLongData) {
                        if (!this.parameterBindings[i].isNull) {
                            this.storeBinding(packet, this.parameterBindings[i], mysql);
                        } else {
                            int n = i / 8;
                            nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << (i & 7));
                        }
                    }
                    ++i;
                }
                int endPosition = packet.getPosition();
                packet.setPosition(nullBitsPosition);
                packet.writeBytesNoNull(nullBitsBuffer);
                packet.setPosition(endPosition);
                long begin = 0L;
                boolean logSlowQueries = this.connection.getLogSlowQueries();
                boolean gatherPerformanceMetrics = this.connection.getGatherPerformanceMetrics();
                if (this.profileSQL || logSlowQueries || gatherPerformanceMetrics) {
                    begin = mysql.getCurrentTimeNanosOrMillis();
                }
                this.resetCancelledState();
                TimerTask timeoutTask = null;
                try {
                    if (this.connection.getEnableQueryTimeouts() && this.timeoutInMillis != 0 && this.connection.versionMeetsMinimum(5, 0, 0)) {
                        timeoutTask = new StatementImpl.CancelTask(this, this);
                        ConnectionImpl.getCancelTimer().schedule(timeoutTask, this.timeoutInMillis);
                    }
                    Buffer resultPacket = mysql.sendCommand(23, null, packet, false, null, 0);
                    long queryEndTime = 0L;
                    if (logSlowQueries || gatherPerformanceMetrics || this.profileSQL) {
                        queryEndTime = mysql.getCurrentTimeNanosOrMillis();
                    }
                    if (timeoutTask != null) {
                        timeoutTask.cancel();
                        if (((StatementImpl.CancelTask)timeoutTask).caughtWhileCancelling != null) {
                            throw ((StatementImpl.CancelTask)timeoutTask).caughtWhileCancelling;
                        }
                        timeoutTask = null;
                    }
                    Object object2 = this.cancelTimeoutMutex;
                    synchronized (object2) {
                        if (this.wasCancelled) {
                            SQLException cause = null;
                            cause = this.wasCancelledByTimeout ? new MySQLTimeoutException() : new MySQLStatementCancelledException();
                            this.resetCancelledState();
                            throw cause;
                        }
                    }
                    boolean queryWasSlow = false;
                    if (logSlowQueries || gatherPerformanceMetrics) {
                        long elapsedTime = queryEndTime - begin;
                        if (logSlowQueries) {
                            if (this.useAutoSlowLog) {
                                queryWasSlow = elapsedTime > (long)this.connection.getSlowQueryThresholdMillis();
                            } else {
                                queryWasSlow = this.connection.isAbonormallyLongQuery(elapsedTime);
                                this.connection.reportQueryTime(elapsedTime);
                            }
                        }
                        if (queryWasSlow) {
                            StringBuffer mesgBuf = new StringBuffer(48 + this.originalSql.length());
                            mesgBuf.append(Messages.getString("ServerPreparedStatement.15"));
                            mesgBuf.append(mysql.getSlowQueryThreshold());
                            mesgBuf.append(Messages.getString("ServerPreparedStatement.15a"));
                            mesgBuf.append(elapsedTime);
                            mesgBuf.append(Messages.getString("ServerPreparedStatement.16"));
                            mesgBuf.append("as prepared: ");
                            mesgBuf.append(this.originalSql);
                            mesgBuf.append("\n\n with parameters bound:\n\n");
                            mesgBuf.append(this.asSql(true));
                            this.eventSink.consumeEvent(new ProfilerEvent(6, "", this.currentCatalog, this.connection.getId(), this.getId(), 0, System.currentTimeMillis(), elapsedTime, mysql.getQueryTimingUnits(), null, new Throwable(), mesgBuf.toString()));
                        }
                        if (gatherPerformanceMetrics) {
                            this.connection.registerQueryExecutionTime(elapsedTime);
                        }
                    }
                    this.connection.incrementNumberOfPreparedExecutes();
                    if (this.profileSQL) {
                        this.eventSink = ProfilerEventHandlerFactory.getInstance(this.connection);
                        this.eventSink.consumeEvent(new ProfilerEvent(4, "", this.currentCatalog, this.connectionId, this.statementId, -1, System.currentTimeMillis(), (int)(mysql.getCurrentTimeNanosOrMillis() - begin), mysql.getQueryTimingUnits(), null, new Throwable(), this.truncateQueryToLog(this.asSql(true))));
                    }
                    ResultSetImpl rs = mysql.readAllResults(this, maxRowsToRetrieve, this.resultSetType, this.resultSetConcurrency, createStreamingResultSet, this.currentCatalog, resultPacket, true, this.fieldCount, metadataFromCache);
                    if (this.profileSQL) {
                        long fetchEndTime = mysql.getCurrentTimeNanosOrMillis();
                        this.eventSink.consumeEvent(new ProfilerEvent(5, "", this.currentCatalog, this.connection.getId(), this.getId(), 0, System.currentTimeMillis(), fetchEndTime - queryEndTime, mysql.getQueryTimingUnits(), null, new Throwable(), null));
                    }
                    if (queryWasSlow && this.connection.getExplainSlowQueries()) {
                        String queryAsString = this.asSql(true);
                        mysql.explainSlowQuery(queryAsString.getBytes(), queryAsString);
                    }
                    if (!createStreamingResultSet && this.serverNeedsResetBeforeEachExecution) {
                        this.serverResetStatement();
                    }
                    this.sendTypesToServer = false;
                    this.results = rs;
                    if (mysql.hadWarnings()) {
                        mysql.scanForAndThrowDataTruncation();
                    }
                    resultSetImpl = rs;
                    if (timeoutTask == null) break block46;
                }
                catch (Throwable throwable) {
                    if (timeoutTask != null) {
                        timeoutTask.cancel();
                    }
                    throw throwable;
                }
                timeoutTask.cancel();
            }
            return resultSetImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverLongData(int parameterIndex, BindValue longData) throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            Object value = longData.value;
            if (value instanceof byte[]) {
                packet.clear();
                packet.writeByte((byte)24);
                packet.writeLong(this.serverStatementId);
                packet.writeInt(parameterIndex);
                packet.writeBytesNoNull((byte[])longData.value);
                mysql.sendCommand(24, null, packet, true, null, 0);
            } else if (value instanceof InputStream) {
                this.storeStream(mysql, parameterIndex, packet, (InputStream)value);
            } else if (value instanceof Blob) {
                this.storeStream(mysql, parameterIndex, packet, ((Blob)value).getBinaryStream());
            } else if (value instanceof Reader) {
                this.storeReader(mysql, parameterIndex, packet, (Reader)value);
            } else {
                throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.18")) + value.getClass().getName() + "'", "S1009", this.getExceptionInterceptor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void serverPrepare(String sql) throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            block19: {
                MysqlIO mysql = this.connection.getIO();
                if (this.connection.getAutoGenerateTestcaseScript()) {
                    this.dumpPrepareForTestcase();
                }
                try {
                    try {
                        int i;
                        long begin = 0L;
                        this.isLoadDataQuery = StringUtils.startsWithIgnoreCaseAndWs(sql, "LOAD DATA");
                        if (this.connection.getProfileSql()) {
                            begin = System.currentTimeMillis();
                        }
                        String characterEncoding = null;
                        String connectionEncoding = this.connection.getEncoding();
                        if (!this.isLoadDataQuery && this.connection.getUseUnicode() && connectionEncoding != null) {
                            characterEncoding = connectionEncoding;
                        }
                        Buffer prepareResultPacket = mysql.sendCommand(22, sql, null, false, characterEncoding, 0);
                        if (this.connection.versionMeetsMinimum(4, 1, 1)) {
                            prepareResultPacket.setPosition(1);
                        } else {
                            prepareResultPacket.setPosition(0);
                        }
                        this.serverStatementId = prepareResultPacket.readLong();
                        this.fieldCount = prepareResultPacket.readInt();
                        this.parameterCount = prepareResultPacket.readInt();
                        this.parameterBindings = new BindValue[this.parameterCount];
                        int i2 = 0;
                        while (i2 < this.parameterCount) {
                            this.parameterBindings[i2] = new BindValue();
                            ++i2;
                        }
                        this.connection.incrementNumberOfPrepares();
                        if (this.profileSQL) {
                            this.eventSink.consumeEvent(new ProfilerEvent(2, "", this.currentCatalog, this.connectionId, this.statementId, -1, System.currentTimeMillis(), mysql.getCurrentTimeNanosOrMillis() - begin, mysql.getQueryTimingUnits(), null, new Throwable(), this.truncateQueryToLog(sql)));
                        }
                        if (this.parameterCount > 0 && this.connection.versionMeetsMinimum(4, 1, 2) && !mysql.isVersion(5, 0, 0)) {
                            this.parameterFields = new Field[this.parameterCount];
                            Buffer metaDataPacket = mysql.readPacket();
                            i = 0;
                            while (!metaDataPacket.isLastDataPacket() && i < this.parameterCount) {
                                this.parameterFields[i++] = mysql.unpackField(metaDataPacket, false);
                                metaDataPacket = mysql.readPacket();
                            }
                        }
                        if (this.fieldCount <= 0) return;
                        this.resultFields = new Field[this.fieldCount];
                        Buffer fieldPacket = mysql.readPacket();
                        i = 0;
                        if (true) {
                            if (fieldPacket.isLastDataPacket()) return;
                            if (i >= this.fieldCount) break block19;
                        }
                        do {
                            this.resultFields[i++] = mysql.unpackField(fieldPacket, false);
                            fieldPacket = mysql.readPacket();
                            if (fieldPacket.isLastDataPacket()) return;
                        } while (i < this.fieldCount);
                    }
                    catch (SQLException sqlEx) {
                        if (!this.connection.getDumpQueriesOnException()) throw sqlEx;
                        StringBuffer messageBuf = new StringBuffer(this.originalSql.length() + 32);
                        messageBuf.append("\n\nQuery being prepared when exception was thrown:\n\n");
                        messageBuf.append(this.originalSql);
                        sqlEx = ConnectionImpl.appendMessageToException(sqlEx, messageBuf.toString(), this.getExceptionInterceptor());
                        throw sqlEx;
                    }
                }
                finally {
                    this.connection.getIO().clearInputStream();
                }
            }
            return;
        }
    }

    private String truncateQueryToLog(String sql) {
        String query = null;
        if (sql.length() > this.connection.getMaxQuerySizeToLog()) {
            StringBuffer queryBuf = new StringBuffer(this.connection.getMaxQuerySizeToLog() + 12);
            queryBuf.append(sql.substring(0, this.connection.getMaxQuerySizeToLog()));
            queryBuf.append(Messages.getString("MysqlIO.25"));
            query = queryBuf.toString();
        } else {
            query = sql;
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverResetStatement() throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            packet.clear();
            packet.writeByte((byte)26);
            packet.writeLong(this.serverStatementId);
            try {
                try {
                    mysql.sendCommand(26, null, packet, !this.connection.versionMeetsMinimum(4, 1, 2), null, 0);
                }
                catch (SQLException sqlEx) {
                    throw sqlEx;
                }
                catch (Exception ex) {
                    SQLException sqlEx = SQLError.createSQLException(ex.toString(), "S1000", this.getExceptionInterceptor());
                    sqlEx.initCause(ex);
                    throw sqlEx;
                }
            }
            finally {
                mysql.clearInputStream();
            }
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        throw SQLError.notImplemented();
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : -1L;
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            if (this.connection.versionMeetsMinimum(5, 0, 3)) {
                this.setType(binding, 246);
            } else {
                this.setType(binding, this.stringTypeCode);
            }
            binding.value = StringUtils.fixDecimalExponent(StringUtils.consistentToString(x));
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : -1L;
        }
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? x.length() : -1L;
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setByte(parameterIndex, x ? (byte)1 : 0);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 1);
        binding.value = null;
        binding.byteBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 253);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkClosed();
        if (reader == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = reader;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : -1L;
        }
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x.getCharacterStream();
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? x.length() : -1L;
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 10);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        if (!this.connection.getAllowNanAndInf() && (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY || Double.isNaN(x))) {
            throw SQLError.createSQLException("'" + x + "' is not a valid numeric or approximate numeric value", "S1009", this.getExceptionInterceptor());
        }
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 5);
        binding.value = null;
        binding.doubleBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 4);
        binding.value = null;
        binding.floatBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 3);
        binding.value = null;
        binding.intBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 8);
        binding.value = null;
        binding.longBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        if (binding.bufferType == 0) {
            this.setType(binding, 6);
        }
        binding.value = null;
        binding.isNull = true;
        binding.isLongData = false;
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        if (binding.bufferType == 0) {
            this.setType(binding, 6);
        }
        binding.value = null;
        binding.isNull = true;
        binding.isLongData = false;
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw SQLError.notImplemented();
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 2);
        binding.value = null;
        binding.shortBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 1);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, this.stringTypeCode);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTimeInternal(parameterIndex, x, null, this.connection.getDefaultTimeZone(), false);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTimeInternal(parameterIndex, x, cal, cal.getTimeZone(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeInternal(int parameterIndex, Time x, Calendar targetCalendar, TimeZone tz, boolean rollForward) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 92);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 11);
            if (!this.useLegacyDatetimeCode) {
                binding.value = x;
            } else {
                Calendar sessionCalendar;
                Calendar calendar = sessionCalendar = this.getCalendarInstanceForSessionOrNew();
                synchronized (calendar) {
                    binding.value = TimeUtil.changeTimezone(this.connection, sessionCalendar, targetCalendar, x, tz, this.connection.getServerTimezoneTZ(), rollForward);
                }
            }
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestampInternal(parameterIndex, x, null, this.connection.getDefaultTimeZone(), false);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestampInternal(parameterIndex, x, cal, cal.getTimeZone(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTimestampInternal(int parameterIndex, Timestamp x, Calendar targetCalendar, TimeZone tz, boolean rollForward) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 12);
            if (!this.useLegacyDatetimeCode) {
                binding.value = x;
            } else {
                Calendar sessionCalendar;
                Calendar calendar = sessionCalendar = this.connection.getUseJDBCCompliantTimezoneShift() ? this.connection.getUtcCalendar() : this.getCalendarInstanceForSessionOrNew();
                synchronized (calendar) {
                    binding.value = TimeUtil.changeTimezone(this.connection, sessionCalendar, targetCalendar, x, tz, this.connection.getServerTimezoneTZ(), rollForward);
                }
                binding.isNull = false;
                binding.isLongData = false;
            }
        }
    }

    protected void setType(BindValue oldValue, int bufferType) {
        if (oldValue.bufferType != bufferType) {
            this.sendTypesToServer = true;
        }
        oldValue.bufferType = bufferType;
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        throw SQLError.notImplemented();
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkClosed();
        this.setString(parameterIndex, x.toString());
    }

    private void storeBinding(Buffer packet, BindValue bindValue, MysqlIO mysql) throws SQLException {
        try {
            Object value = bindValue.value;
            switch (bindValue.bufferType) {
                case 1: {
                    packet.writeByte(bindValue.byteBinding);
                    return;
                }
                case 2: {
                    packet.ensureCapacity(2);
                    packet.writeInt(bindValue.shortBinding);
                    return;
                }
                case 3: {
                    packet.ensureCapacity(4);
                    packet.writeLong(bindValue.intBinding);
                    return;
                }
                case 8: {
                    packet.ensureCapacity(8);
                    packet.writeLongLong(bindValue.longBinding);
                    return;
                }
                case 4: {
                    packet.ensureCapacity(4);
                    packet.writeFloat(bindValue.floatBinding);
                    return;
                }
                case 5: {
                    packet.ensureCapacity(8);
                    packet.writeDouble(bindValue.doubleBinding);
                    return;
                }
                case 11: {
                    this.storeTime(packet, (Time)value);
                    return;
                }
                case 7: 
                case 10: 
                case 12: {
                    this.storeDateTime(packet, (java.util.Date)value, mysql, bindValue.bufferType);
                    return;
                }
                case 0: 
                case 15: 
                case 246: 
                case 253: 
                case 254: {
                    if (value instanceof byte[]) {
                        packet.writeLenBytes((byte[])value);
                    } else if (!this.isLoadDataQuery) {
                        packet.writeLenString((String)value, this.charEncoding, this.connection.getServerCharacterEncoding(), this.charConverter, this.connection.parserKnowsUnicode(), this.connection);
                    } else {
                        packet.writeLenBytes(((String)value).getBytes());
                    }
                    return;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.22")) + this.connection.getEncoding() + "'", "S1000", this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDateTime412AndOlder(Buffer intoBuf, java.util.Date dt, int bufferType) throws SQLException {
        Calendar sessionCalendar = null;
        sessionCalendar = !this.useLegacyDatetimeCode ? (bufferType == 10 ? this.getDefaultTzCalendar() : this.getServerTzCalendar()) : (dt instanceof Timestamp && this.connection.getUseJDBCCompliantTimezoneShift() ? this.connection.getUtcCalendar() : this.getCalendarInstanceForSessionOrNew());
        Calendar calendar = sessionCalendar;
        synchronized (calendar) {
            java.util.Date oldTime = sessionCalendar.getTime();
            try {
                intoBuf.ensureCapacity(8);
                intoBuf.writeByte((byte)7);
                sessionCalendar.setTime(dt);
                int year = sessionCalendar.get(1);
                int month = sessionCalendar.get(2) + 1;
                int date = sessionCalendar.get(5);
                intoBuf.writeInt(year);
                intoBuf.writeByte((byte)month);
                intoBuf.writeByte((byte)date);
                if (dt instanceof Date) {
                    intoBuf.writeByte((byte)0);
                    intoBuf.writeByte((byte)0);
                    intoBuf.writeByte((byte)0);
                } else {
                    intoBuf.writeByte((byte)sessionCalendar.get(11));
                    intoBuf.writeByte((byte)sessionCalendar.get(12));
                    intoBuf.writeByte((byte)sessionCalendar.get(13));
                }
            }
            finally {
                sessionCalendar.setTime(oldTime);
            }
        }
    }

    private void storeDateTime(Buffer intoBuf, java.util.Date dt, MysqlIO mysql, int bufferType) throws SQLException {
        if (this.connection.versionMeetsMinimum(4, 1, 3)) {
            this.storeDateTime413AndNewer(intoBuf, dt, bufferType);
        } else {
            this.storeDateTime412AndOlder(intoBuf, dt, bufferType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDateTime413AndNewer(Buffer intoBuf, java.util.Date dt, int bufferType) throws SQLException {
        Calendar sessionCalendar = null;
        sessionCalendar = !this.useLegacyDatetimeCode ? (bufferType == 10 ? this.getDefaultTzCalendar() : this.getServerTzCalendar()) : (dt instanceof Timestamp && this.connection.getUseJDBCCompliantTimezoneShift() ? this.connection.getUtcCalendar() : this.getCalendarInstanceForSessionOrNew());
        Calendar calendar = sessionCalendar;
        synchronized (calendar) {
            java.util.Date oldTime = sessionCalendar.getTime();
            try {
                sessionCalendar.setTime(dt);
                if (dt instanceof Date) {
                    sessionCalendar.set(11, 0);
                    sessionCalendar.set(12, 0);
                    sessionCalendar.set(13, 0);
                }
                byte length = 7;
                if (dt instanceof Timestamp) {
                    length = 11;
                }
                intoBuf.ensureCapacity(length);
                intoBuf.writeByte(length);
                int year = sessionCalendar.get(1);
                int month = sessionCalendar.get(2) + 1;
                int date = sessionCalendar.get(5);
                intoBuf.writeInt(year);
                intoBuf.writeByte((byte)month);
                intoBuf.writeByte((byte)date);
                if (dt instanceof Date) {
                    intoBuf.writeByte((byte)0);
                    intoBuf.writeByte((byte)0);
                    intoBuf.writeByte((byte)0);
                } else {
                    intoBuf.writeByte((byte)sessionCalendar.get(11));
                    intoBuf.writeByte((byte)sessionCalendar.get(12));
                    intoBuf.writeByte((byte)sessionCalendar.get(13));
                }
                if (length == 11) {
                    intoBuf.writeLong(((Timestamp)dt).getNanos() / 1000);
                }
            }
            finally {
                sessionCalendar.setTime(oldTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Calendar getServerTzCalendar() {
        ServerPreparedStatement serverPreparedStatement = this;
        synchronized (serverPreparedStatement) {
            if (this.serverTzCalendar == null) {
                this.serverTzCalendar = new GregorianCalendar(this.connection.getServerTimezoneTZ());
            }
            return this.serverTzCalendar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Calendar getDefaultTzCalendar() {
        ServerPreparedStatement serverPreparedStatement = this;
        synchronized (serverPreparedStatement) {
            if (this.defaultTzCalendar == null) {
                this.defaultTzCalendar = new GregorianCalendar(TimeZone.getDefault());
            }
            return this.defaultTzCalendar;
        }
    }

    private void storeReader(MysqlIO mysql, int parameterIndex, Buffer packet, Reader inStream) throws SQLException {
        String forcedEncoding = this.connection.getClobCharacterEncoding();
        String clobEncoding = forcedEncoding == null ? this.connection.getEncoding() : forcedEncoding;
        int maxBytesChar = 2;
        if (clobEncoding != null) {
            if (!clobEncoding.equals("UTF-16")) {
                maxBytesChar = this.connection.getMaxBytesPerChar(clobEncoding);
                if (maxBytesChar == 1) {
                    maxBytesChar = 2;
                }
            } else {
                maxBytesChar = 4;
            }
        }
        char[] buf = new char[8192 / maxBytesChar];
        int numRead = 0;
        int bytesInPacket = 0;
        int totalBytesRead = 0;
        int bytesReadAtLastSend = 0;
        int packetIsFullAt = this.connection.getBlobSendChunkSize();
        try {
            try {
                packet.clear();
                packet.writeByte((byte)24);
                packet.writeLong(this.serverStatementId);
                packet.writeInt(parameterIndex);
                boolean readAny = false;
                while ((numRead = inStream.read(buf)) != -1) {
                    readAny = true;
                    byte[] valueAsBytes = StringUtils.getBytes(buf, null, clobEncoding, this.connection.getServerCharacterEncoding(), 0, numRead, this.connection.parserKnowsUnicode(), this.getExceptionInterceptor());
                    packet.writeBytesNoNull(valueAsBytes, 0, valueAsBytes.length);
                    totalBytesRead += valueAsBytes.length;
                    if ((bytesInPacket += valueAsBytes.length) < packetIsFullAt) continue;
                    bytesReadAtLastSend = totalBytesRead;
                    mysql.sendCommand(24, null, packet, true, null, 0);
                    bytesInPacket = 0;
                    packet.clear();
                    packet.writeByte((byte)24);
                    packet.writeLong(this.serverStatementId);
                    packet.writeInt(parameterIndex);
                }
                if (totalBytesRead != bytesReadAtLastSend) {
                    mysql.sendCommand(24, null, packet, true, null, 0);
                }
                if (!readAny) {
                    mysql.sendCommand(24, null, packet, true, null, 0);
                }
            }
            catch (IOException ioEx) {
                SQLException sqlEx = SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.24")) + ioEx.toString(), "S1000", this.getExceptionInterceptor());
                sqlEx.initCause(ioEx);
                throw sqlEx;
            }
        }
        catch (Throwable throwable) {
            if (this.connection.getAutoClosePStmtStreams() && inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (this.connection.getAutoClosePStmtStreams() && inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void storeStream(MysqlIO mysql, int parameterIndex, Buffer packet, InputStream inStream) throws SQLException {
        byte[] buf = new byte[8192];
        int numRead = 0;
        try {
            try {
                int bytesInPacket = 0;
                int totalBytesRead = 0;
                int bytesReadAtLastSend = 0;
                int packetIsFullAt = this.connection.getBlobSendChunkSize();
                packet.clear();
                packet.writeByte((byte)24);
                packet.writeLong(this.serverStatementId);
                packet.writeInt(parameterIndex);
                boolean readAny = false;
                while ((numRead = inStream.read(buf)) != -1) {
                    readAny = true;
                    packet.writeBytesNoNull(buf, 0, numRead);
                    totalBytesRead += numRead;
                    if ((bytesInPacket += numRead) < packetIsFullAt) continue;
                    bytesReadAtLastSend = totalBytesRead;
                    mysql.sendCommand(24, null, packet, true, null, 0);
                    bytesInPacket = 0;
                    packet.clear();
                    packet.writeByte((byte)24);
                    packet.writeLong(this.serverStatementId);
                    packet.writeInt(parameterIndex);
                }
                if (totalBytesRead != bytesReadAtLastSend) {
                    mysql.sendCommand(24, null, packet, true, null, 0);
                }
                if (!readAny) {
                    mysql.sendCommand(24, null, packet, true, null, 0);
                }
            }
            catch (IOException ioEx) {
                SQLException sqlEx = SQLError.createSQLException(String.valueOf(Messages.getString("ServerPreparedStatement.25")) + ioEx.toString(), "S1000", this.getExceptionInterceptor());
                sqlEx.initCause(ioEx);
                throw sqlEx;
            }
        }
        catch (Throwable throwable) {
            if (this.connection.getAutoClosePStmtStreams() && inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (this.connection.getAutoClosePStmtStreams() && inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        StringBuffer toStringBuf = new StringBuffer();
        toStringBuf.append("com.mysql.jdbc.ServerPreparedStatement[");
        toStringBuf.append(this.serverStatementId);
        toStringBuf.append("] - ");
        try {
            toStringBuf.append(this.asSql());
        }
        catch (SQLException sqlEx) {
            toStringBuf.append(Messages.getString("ServerPreparedStatement.6"));
            toStringBuf.append(sqlEx);
        }
        return toStringBuf.toString();
    }

    protected long getServerStatementId() {
        return this.serverStatementId;
    }

    public synchronized boolean canRewriteAsMultiValueInsertAtSqlLevel() throws SQLException {
        if (!this.hasCheckedRewrite) {
            this.hasCheckedRewrite = true;
            this.canRewrite = ServerPreparedStatement.canRewrite(this.originalSql, this.isOnDuplicateKeyUpdate(), this.getLocationOfOnDuplicateKeyUpdate(), 0);
            this.parseInfo = new PreparedStatement.ParseInfo(this, this.originalSql, this.connection, this.connection.getMetaData(), this.charEncoding, this.charConverter);
        }
        return this.canRewrite;
    }

    public synchronized boolean canRewriteAsMultivalueInsertStatement() throws SQLException {
        if (!this.canRewriteAsMultiValueInsertAtSqlLevel()) {
            return false;
        }
        BindValue[] currentBindValues = null;
        BindValue[] previousBindValues = null;
        int nbrCommands = this.batchedArgs.size();
        int commandIndex = 0;
        while (commandIndex < nbrCommands) {
            Object arg = this.batchedArgs.get(commandIndex);
            if (!(arg instanceof String)) {
                currentBindValues = ((BatchedBindValues)arg).batchedParameterValues;
                if (previousBindValues != null) {
                    int j = 0;
                    while (j < this.parameterBindings.length) {
                        if (currentBindValues[j].bufferType != previousBindValues[j].bufferType) {
                            return false;
                        }
                        ++j;
                    }
                }
            }
            ++commandIndex;
        }
        return true;
    }

    protected synchronized int getLocationOfOnDuplicateKeyUpdate() {
        if (this.locationOfOnDuplicateKeyUpdate == -2) {
            this.locationOfOnDuplicateKeyUpdate = this.getOnDuplicateKeyLocation(this.originalSql);
        }
        return this.locationOfOnDuplicateKeyUpdate;
    }

    protected synchronized boolean isOnDuplicateKeyUpdate() {
        return this.getLocationOfOnDuplicateKeyUpdate() != -1;
    }

    protected long[] computeMaxParameterSetSizeAndBatchSize(int numBatchedArgs) {
        long sizeOfEntireBatch = 10L;
        long maxSizeOfParameterSet = 0L;
        int i = 0;
        while (i < numBatchedArgs) {
            BindValue[] paramArg = ((BatchedBindValues)this.batchedArgs.get((int)i)).batchedParameterValues;
            long sizeOfParameterSet = 0L;
            sizeOfParameterSet += (long)((this.parameterCount + 7) / 8);
            sizeOfParameterSet += (long)(this.parameterCount * 2);
            int j = 0;
            while (j < this.parameterBindings.length) {
                if (!paramArg[j].isNull) {
                    long size = paramArg[j].getBoundLength();
                    if (paramArg[j].isLongData) {
                        if (size != -1L) {
                            sizeOfParameterSet += size;
                        }
                    } else {
                        sizeOfParameterSet += size;
                    }
                }
                ++j;
            }
            sizeOfEntireBatch += sizeOfParameterSet;
            if (sizeOfParameterSet > maxSizeOfParameterSet) {
                maxSizeOfParameterSet = sizeOfParameterSet;
            }
            ++i;
        }
        return new long[]{maxSizeOfParameterSet, sizeOfEntireBatch};
    }

    protected int setOneBatchedParameterSet(java.sql.PreparedStatement batchedStatement, int batchedParamIndex, Object paramSet) throws SQLException {
        BindValue[] paramArg = ((BatchedBindValues)paramSet).batchedParameterValues;
        int j = 0;
        while (j < paramArg.length) {
            Object value;
            if (paramArg[j].isNull) {
                batchedStatement.setNull(batchedParamIndex++, 0);
            } else if (paramArg[j].isLongData) {
                value = paramArg[j].value;
                if (value instanceof InputStream) {
                    batchedStatement.setBinaryStream(batchedParamIndex++, (InputStream)value, (int)paramArg[j].bindLength);
                } else {
                    batchedStatement.setCharacterStream(batchedParamIndex++, (Reader)value, (int)paramArg[j].bindLength);
                }
            } else {
                switch (paramArg[j].bufferType) {
                    case 1: {
                        batchedStatement.setByte(batchedParamIndex++, paramArg[j].byteBinding);
                        break;
                    }
                    case 2: {
                        batchedStatement.setShort(batchedParamIndex++, paramArg[j].shortBinding);
                        break;
                    }
                    case 3: {
                        batchedStatement.setInt(batchedParamIndex++, paramArg[j].intBinding);
                        break;
                    }
                    case 8: {
                        batchedStatement.setLong(batchedParamIndex++, paramArg[j].longBinding);
                        break;
                    }
                    case 4: {
                        batchedStatement.setFloat(batchedParamIndex++, paramArg[j].floatBinding);
                        break;
                    }
                    case 5: {
                        batchedStatement.setDouble(batchedParamIndex++, paramArg[j].doubleBinding);
                        break;
                    }
                    case 11: {
                        batchedStatement.setTime(batchedParamIndex++, (Time)paramArg[j].value);
                        break;
                    }
                    case 10: {
                        batchedStatement.setDate(batchedParamIndex++, (Date)paramArg[j].value);
                        break;
                    }
                    case 7: 
                    case 12: {
                        batchedStatement.setTimestamp(batchedParamIndex++, (Timestamp)paramArg[j].value);
                        break;
                    }
                    case 0: 
                    case 15: 
                    case 246: 
                    case 253: 
                    case 254: {
                        value = paramArg[j].value;
                        if (value instanceof byte[]) {
                            batchedStatement.setBytes(batchedParamIndex, (byte[])value);
                        } else {
                            batchedStatement.setString(batchedParamIndex, (String)value);
                        }
                        if (batchedStatement instanceof ServerPreparedStatement) {
                            BindValue asBound = ((ServerPreparedStatement)batchedStatement).getBinding(batchedParamIndex, false);
                            asBound.bufferType = paramArg[j].bufferType;
                        }
                        ++batchedParamIndex;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type when re-binding parameter into batched statement for parameter index " + batchedParamIndex);
                    }
                }
            }
            ++j;
        }
        return batchedParamIndex;
    }

    protected boolean containsOnDuplicateKeyUpdateInSQL() {
        return this.hasOnDuplicateKeyUpdate;
    }

    protected PreparedStatement prepareBatchedInsertSQL(ConnectionImpl localConn, int numBatches) throws SQLException {
        try {
            ServerPreparedStatement pstmt = new ServerPreparedStatement(localConn, this.parseInfo.getSqlForBatch(numBatches), this.currentCatalog, this.resultSetConcurrency, this.resultSetType);
            pstmt.setRetrieveGeneratedKeys(this.retrieveGeneratedKeys);
            return pstmt;
        }
        catch (UnsupportedEncodingException e) {
            SQLException sqlEx = SQLError.createSQLException("Unable to prepare batch statement", "S1000", this.getExceptionInterceptor());
            sqlEx.initCause(e);
            throw sqlEx;
        }
    }

    static class BatchedBindValues {
        BindValue[] batchedParameterValues;

        BatchedBindValues(BindValue[] paramVals) {
            int numParams = paramVals.length;
            this.batchedParameterValues = new BindValue[numParams];
            int i = 0;
            while (i < numParams) {
                this.batchedParameterValues[i] = new BindValue(paramVals[i]);
                ++i;
            }
        }
    }

    public static class BindValue {
        long boundBeforeExecutionNum = 0L;
        public long bindLength;
        int bufferType;
        byte byteBinding;
        double doubleBinding;
        float floatBinding;
        int intBinding;
        public boolean isLongData;
        public boolean isNull;
        boolean isSet = false;
        long longBinding;
        short shortBinding;
        public Object value;

        BindValue() {
        }

        BindValue(BindValue copyMe) {
            this.value = copyMe.value;
            this.isSet = copyMe.isSet;
            this.isLongData = copyMe.isLongData;
            this.isNull = copyMe.isNull;
            this.bufferType = copyMe.bufferType;
            this.bindLength = copyMe.bindLength;
            this.byteBinding = copyMe.byteBinding;
            this.shortBinding = copyMe.shortBinding;
            this.intBinding = copyMe.intBinding;
            this.longBinding = copyMe.longBinding;
            this.floatBinding = copyMe.floatBinding;
            this.doubleBinding = copyMe.doubleBinding;
        }

        void reset() {
            this.isSet = false;
            this.value = null;
            this.isLongData = false;
            this.byteBinding = 0;
            this.shortBinding = 0;
            this.intBinding = 0;
            this.longBinding = 0L;
            this.floatBinding = 0.0f;
            this.doubleBinding = 0.0;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean quoteIfNeeded) {
            if (this.isLongData) {
                return "' STREAM DATA '";
            }
            switch (this.bufferType) {
                case 1: {
                    return String.valueOf(this.byteBinding);
                }
                case 2: {
                    return String.valueOf(this.shortBinding);
                }
                case 3: {
                    return String.valueOf(this.intBinding);
                }
                case 8: {
                    return String.valueOf(this.longBinding);
                }
                case 4: {
                    return String.valueOf(this.floatBinding);
                }
                case 5: {
                    return String.valueOf(this.doubleBinding);
                }
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 253: 
                case 254: {
                    if (quoteIfNeeded) {
                        return "'" + String.valueOf(this.value) + "'";
                    }
                    return String.valueOf(this.value);
                }
            }
            if (this.value instanceof byte[]) {
                return "byte data";
            }
            if (quoteIfNeeded) {
                return "'" + String.valueOf(this.value) + "'";
            }
            return String.valueOf(this.value);
        }

        long getBoundLength() {
            if (this.isNull) {
                return 0L;
            }
            if (this.isLongData) {
                return this.bindLength;
            }
            switch (this.bufferType) {
                case 1: {
                    return 1L;
                }
                case 2: {
                    return 2L;
                }
                case 3: {
                    return 4L;
                }
                case 8: {
                    return 8L;
                }
                case 4: {
                    return 4L;
                }
                case 5: {
                    return 8L;
                }
                case 11: {
                    return 9L;
                }
                case 10: {
                    return 7L;
                }
                case 7: 
                case 12: {
                    return 11L;
                }
                case 0: 
                case 15: 
                case 246: 
                case 253: 
                case 254: {
                    if (this.value instanceof byte[]) {
                        return ((byte[])this.value).length;
                    }
                    return ((String)this.value).length();
                }
            }
            return 0L;
        }
    }
}

