/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command;

import java.util.logging.Logger;
import org.drupal.project.async_command.CommandRecord;
import org.drupal.project.async_command.DrupalUtils;
import org.drupal.project.async_command.GenericDrupalApp;

public abstract class AsyncCommand
implements Runnable {
    protected static Logger logger = DrupalUtils.getPackageLogger();
    protected final GenericDrupalApp drupalApp;
    protected final CommandRecord record;

    public AsyncCommand(CommandRecord record, GenericDrupalApp drupalApp) {
        assert (record != null && drupalApp != null);
        this.record = record;
        this.drupalApp = drupalApp;
    }

    public String getIdentifier() {
        return DrupalUtils.getIdentifier(this.getClass());
    }

    @Override
    public abstract void run();

    public AsyncCommand evaluate(String ... params) {
        throw new UnsupportedOperationException("This command does not support evaluate() method.");
    }

    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status SUCCESS = new Status("OKOK");
        public static final /* enum */ Status FAILURE = new Status("FAIL");
        public static final /* enum */ Status RUNNING = new Status("RUNN");
        public static final /* enum */ Status FORCED_STOP = new Status("STOP");
        public static final /* enum */ Status UNRECOGNIZED = new Status("NREC");
        public static final /* enum */ Status PENDING = new Status("PEND");
        private final String statusToken;
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String name) {
            return Enum.valueOf(Status.class, name);
        }

        private Status(String token) {
            assert (token.length() == 4);
            this.statusToken = token;
        }

        public String toString() {
            return this.statusToken;
        }

        public static Status parse(String token) {
            for (Status status : (Status[])Status.class.getEnumConstants()) {
                if (!status.statusToken.equals(token)) continue;
                return status;
            }
            throw new IllegalArgumentException("Cannot parse status token: " + token);
        }

        static {
            $VALUES = new Status[]{SUCCESS, FAILURE, RUNNING, FORCED_STOP, UNRECOGNIZED, PENDING};
        }
    }
}

