/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import org.apache.commons.dbutils.QueryRunner;
import org.drupal.project.async_command.DrupalUtils;
import org.drupal.project.async_command.exception.DrupalDatabaseException;
import org.drupal.project.async_command.exception.DrupalRuntimeException;

public class BatchUploader
extends Thread {
    private static Logger logger = DrupalUtils.getPackageLogger();
    private final BlockingQueue<Object[]> queue = new LinkedBlockingQueue<Object[]>();
    private final Connection connection;
    private final PreparedStatement preparedSql;
    private int batchSize;
    private boolean accomplished = false;

    public BatchUploader(String threadName, Connection connection, String sql) {
        this(null, threadName, connection, sql, 0);
    }

    public BatchUploader(ThreadGroup threadGroup, String threadName, Connection connection, String sql, int batchSize) {
        super(threadGroup, threadName);
        this.connection = connection;
        this.batchSize = batchSize;
        try {
            this.preparedSql = connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new DrupalDatabaseException(e);
        }
    }

    public synchronized void put(Object ... row) {
        try {
            this.queue.put(row);
        }
        catch (InterruptedException e) {
            throw new DrupalRuntimeException(e);
        }
        finally {
            this.notifyAll();
        }
    }

    public synchronized void accomplish() {
        this.accomplished = true;
        this.notifyAll();
    }

    @Override
    public synchronized void run() {
        QueryRunner qr = new QueryRunner();
        ArrayList rows = new ArrayList();
        int num = 0;
        int index = 0;
        while (true) {
            if ((num = this.queue.drainTo(rows)) > 0) {
                logger.fine("Processing " + num + " rows in BatchUploader " + this.getName());
                try {
                    for (index = 0; index < num; ++index) {
                        qr.fillStatement(this.preparedSql, (Object[])rows.get(index));
                        this.preparedSql.addBatch();
                        if (this.batchSize <= 0 || index <= 0 || index % this.batchSize != 0) continue;
                        this.preparedSql.executeBatch();
                    }
                    if (this.batchSize <= 0 || index % this.batchSize != 0) {
                        this.preparedSql.executeBatch();
                    }
                    rows.clear();
                }
                catch (SQLException e) {
                    throw new DrupalDatabaseException(e);
                }
            }
            if (this.accomplished) break;
            logger.finest("No rows in queue. Wait.");
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new DrupalRuntimeException(e);
            }
        }
        logger.fine("Finished processing BatchUploader: " + this.getName());
    }
}

