/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.drupal.project.async_command.DrupalConnection;
import org.drupal.project.async_command.DrupalUtils;
import org.drupal.project.async_command.GenericDrupalApp;
import org.drupal.project.async_command.exception.DrupalConfigException;
import org.drupal.project.async_command.exception.DrupalRuntimeException;

public class CommandLineLauncher {
    private static Logger logger = DrupalUtils.getPackageLogger();
    private Class drupalAppClass;
    private GenericDrupalApp drupalApp;
    private File configFile;
    private GenericDrupalApp.RunningMode runningMode;

    public CommandLineLauncher(Class<? extends GenericDrupalApp> drupalAppClass) {
        this.drupalAppClass = drupalAppClass;
    }

    public void launch(String[] args) {
        logger.info("DrupalApp VERSION: 7_1_1");
        Options options = this.buildOptions();
        PosixParser parser = new PosixParser();
        CommandLine shellCommand = null;
        try {
            shellCommand = parser.parse(options, args);
        }
        catch (ParseException exp) {
            logger.severe("Cannot parse parameters. Please use -h to see help. Error message: " + exp.getMessage());
            return;
        }
        this.handleSettings(shellCommand);
        this.constructDrupalApp();
        this.handleExecutables(shellCommand);
    }

    private void handleExecutables(CommandLine command) {
        if (command.hasOption('h')) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Drupal application -- " + this.drupalApp.getIdentifier(), this.buildOptions());
        } else if (command.hasOption('t')) {
            this.drupalApp.getDrupalConnection().connect();
            this.drupalApp.getDrupalConnection().testConnection();
        } else if (!command.hasOption('e')) {
            this.drupalApp.run();
        }
    }

    private void handleSettings(CommandLine shellCommand) {
        if (shellCommand.hasOption('c')) {
            this.configFile = new File(shellCommand.getOptionValue('c'));
            if (!this.configFile.exists()) {
                throw new DrupalConfigException("Config file at '" + this.configFile.getAbsolutePath() + "' does not exist.");
            }
            logger.info("Set configuration file as: " + this.configFile.getAbsolutePath());
        } else {
            try {
                this.configFile = DrupalUtils.getConfigPropertiesFile();
            }
            catch (FileNotFoundException e) {
                throw new DrupalConfigException("Cannot find config.properties under default folders. Use -c to specify the location of config.properties.");
            }
        }
        if (shellCommand.hasOption('r')) {
            String rm = shellCommand.getOptionValue('r');
            try {
                this.runningMode = GenericDrupalApp.RunningMode.valueOf(rm.toUpperCase());
            }
            catch (Exception e) {
                throw new DrupalConfigException("Cannot recognize running mode. Use -h to see the options available");
            }
        } else {
            this.runningMode = GenericDrupalApp.RunningMode.SERIAL;
        }
    }

    private void constructDrupalApp() {
        DrupalConnection drupalConnection = new DrupalConnection(this.configFile);
        try {
            Constructor constructor = this.drupalAppClass.getConstructor(DrupalConnection.class);
            this.drupalApp = (GenericDrupalApp)constructor.newInstance(drupalConnection);
        }
        catch (NoSuchMethodException e) {
            throw new DrupalRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new DrupalRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new DrupalRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new DrupalRuntimeException(e);
        }
        this.drupalApp.setRunningMode(this.runningMode);
    }

    private Options buildOptions() {
        Options options = new Options();
        options.addOption("c", true, "database configuration file");
        options.addOption("r", true, "program running mode: 'first', 'serial' (default), 'parallel', or nonstop");
        options.addOption("h", "help", false, "print this message");
        options.addOption("t", "test", false, "test connection to Drupal database");
        options.addOption("e", "eval", true, "evaluate a command call directly for this DrupalApp");
        return options;
    }
}

