/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.drupal.project.async_command.Identifier;
import org.drupal.project.async_command.exception.DrupalConfigException;
import org.drupal.project.async_command.exception.DrupalRuntimeException;
import org.drupal.project.async_command.exception.EvaluationFailureException;
import org.lorecraft.phparser.SerializedPhpParser;

public final class DrupalUtils {
    private static Logger logger = DrupalUtils.getPackageLogger();
    public static final String VERSION = "7_1_1";

    public static Logger getPackageLogger() {
        return Logger.getLogger("org.drupal.project.async_command");
    }

    public static String evalPhp(String phpCode) {
        String phpCli = System.getenv("PHP_EXEC");
        if (phpCli == null) {
            logger.warning("Please set PHP_EXEC. Use default php executable instead.");
            phpCli = "php";
        }
        String[] cmd = new String[]{phpCli, "-r", phpCode};
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
            if (process.exitValue() != 0) {
                logger.severe("PHP process exception.");
                throw new DrupalRuntimeException("Unexpected PHP error: " + process.exitValue());
            }
            return DrupalUtils.getContent(new InputStreamReader(process.getInputStream()));
        }
        catch (IOException e) {
            logger.severe("Cannot run PHP code. Possible reasons: missing PHP CLI executable or dependent libraries.");
            throw new DrupalRuntimeException(e);
        }
        catch (InterruptedException e) {
            logger.severe("PHP code interrupted.");
            throw new DrupalRuntimeException(e);
        }
    }

    public static String evalPhp(String pattern, Object ... params) {
        assert (pattern != null && !pattern.isEmpty());
        String phpCode = MessageFormat.format(pattern, params);
        return DrupalUtils.evalPhp(phpCode);
    }

    public static Map<String, Object> unserializePhpArray(String serialized) {
        return (Map)DrupalUtils.unserializePhp(serialized);
    }

    public static Object unserializePhp(String serialized) {
        SerializedPhpParser serializedPhpParser = new SerializedPhpParser(serialized);
        return serializedPhpParser.parse();
    }

    public static String getContent(Reader input) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = input.read()) != -1) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String convertBlobToString(Object blobValue) {
        byte[] blobBytes = (byte[])blobValue;
        return new String(blobBytes);
    }

    public static File getDrupalSettingsFile() throws FileNotFoundException {
        return DrupalUtils.locateFile("settings.php");
    }

    public static File getConfigPropertiesFile() throws FileNotFoundException {
        return DrupalUtils.locateFile("config.properties");
    }

    private static File locateFile(String fileName) throws FileNotFoundException {
        File theFile;
        File jarDir = new File(DrupalUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        String jarDirStr = jarDir.getAbsolutePath();
        logger.fine("AsyncCommand jar file location: " + jarDirStr);
        File drupalHome = null;
        try {
            drupalHome = DrupalUtils.getFileFromEnv("DRUPAL_HOME");
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        String identityStr = "sites" + File.separator + "all" + File.separator + "modules" + File.separator;
        int pos = jarDirStr.indexOf(identityStr);
        if (pos != -1) {
            theFile = new File(jarDirStr.substring(0, pos) + "sites" + File.separator + "default" + File.separator + fileName);
        } else {
            String workingDir = System.getProperty("user.dir");
            theFile = new File(workingDir + File.separator + fileName);
        }
        if (theFile.exists()) {
            logger.info("Found file '" + fileName + "' at: " + theFile.getAbsolutePath());
            return theFile;
        }
        throw new FileNotFoundException("Cannot find file '" + fileName + "' under the current working directory or sites/default");
    }

    public static void prepareConfig(Properties config) {
        if (!config.containsKey("driverClassName") && config.containsKey("database_type")) {
            String databaseType = config.getProperty("database_type").toLowerCase();
            if (databaseType.equals("mysql")) {
                config.setProperty("driverClassName", "com.mysql.jdbc.Driver");
            } else if (databaseType.equals("postgresql")) {
                config.setProperty("driverClassName", "org.postgresql.Driver");
            }
        }
        if (!config.containsKey("url") && config.containsKey("database_type") && config.containsKey("database_name") && config.containsKey("host_name")) {
            StringBuffer url = new StringBuffer();
            url.append("jdbc:").append(config.getProperty("database_type").toLowerCase()).append("://").append(config.getProperty("host_name"));
            if (config.containsKey("host_port")) {
                url.append(":").append(config.getProperty("host_port"));
            }
            url.append('/').append(config.getProperty("database_name"));
            config.setProperty("url", url.toString());
        }
        if (!(config.containsKey("username") && config.containsKey("password") && config.containsKey("driverClassName") && config.containsKey("url") && config.containsKey("drupal_version"))) {
            throw new DrupalConfigException("Missing required configuration parameters (username, password, driverClassName, url and drupal_version)");
        }
        if (!config.containsKey("defaultAutoCommit")) {
            config.setProperty("defaultAutoCommit", "false");
        }
    }

    public static Properties convertSettingsToConfig(File settingsFile) {
        String phpCode = "include '" + settingsFile.getAbsolutePath() + "'; echo serialize($databases['default']['default']);";
        String dbSettingsStr = DrupalUtils.evalPhp(phpCode);
        Properties config = new Properties();
        Map<String, Object> dbSettings = DrupalUtils.unserializePhpArray(dbSettingsStr);
        if (!(dbSettings.containsKey("username") && dbSettings.containsKey("password") && dbSettings.containsKey("driver") && dbSettings.containsKey("host") && dbSettings.containsKey("database"))) {
            logger.severe("Can't find necessary database info. Content: " + dbSettingsStr);
            throw new DrupalRuntimeException("Can't find necessary database info.");
        }
        config.put("username", dbSettings.get("username"));
        config.put("password", dbSettings.get("password"));
        config.put("db_prefix", dbSettings.get("prefix"));
        String driverName = ((String)dbSettings.get("driver")).toLowerCase();
        if (driverName.startsWith("mysql")) {
            config.put("database_type", "mysql");
        } else if (driverName.startsWith("pgsql")) {
            config.put("database_type", "postgresql");
        } else {
            throw new DrupalRuntimeException("Only support MySQL and PostgreSQL for now. Please use the config.properties file if you use other DBMS.");
        }
        config.put("host_name", dbSettings.get("host"));
        if (dbSettings.containsKey("port") && !dbSettings.get("port").equals("")) {
            config.put("host_port", dbSettings.get("port"));
        }
        config.put("database_name", dbSettings.get("database"));
        phpCode = "include '" + settingsFile.getAbsolutePath() + "'; echo isset($mcrypt_secret_key) ? $mcrypt_secret_key : substr($drupal_hash_salt, 0, 6);";
        String secretKey = DrupalUtils.evalPhp(phpCode);
        config.put("mcrypt_secret_key", secretKey);
        config.put("drupal_version", Character.valueOf('7'));
        return config;
    }

    public static Properties loadProperties(String configString) {
        Properties config = new Properties();
        try {
            config.load(new StringReader(configString));
        }
        catch (IOException e) {
            throw new DrupalRuntimeException("Cannot read config string.");
        }
        return config;
    }

    public static Properties loadProperties(File configFile) {
        Properties config = new Properties();
        try {
            config.load(new FileReader(configFile));
        }
        catch (IOException e) {
            throw new DrupalRuntimeException("Cannot read config file at " + configFile.getAbsolutePath());
        }
        return config;
    }

    public static long getLocalUnixTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static Long getLong(Object value) {
        if (value == null) {
            return null;
        }
        if (Integer.class.isInstance(value)) {
            return ((Integer)value).longValue();
        }
        if (Long.class.isInstance(value)) {
            return (Long)value;
        }
        if (String.class.isInstance(value)) {
            return Long.valueOf((String)value);
        }
        throw new IllegalArgumentException("Cannot parse value: " + value.toString());
    }

    private static File getFileFromEnv(String env) throws FileNotFoundException {
        String filePath = System.getenv(env);
        if (filePath == null) {
            throw new FileNotFoundException("Please specify system environment variable: " + env);
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("Cannot find file for " + env + ": " + filePath);
        }
        return file;
    }

    public static String executeDrush(String ... vars) throws EvaluationFailureException {
        try {
            File drupalHome = DrupalUtils.getFileFromEnv("DRUPAL_HOME");
            if (!drupalHome.isDirectory()) {
                throw new FileNotFoundException("Please set DRUPAL_HOME correctly.");
            }
            File drushHome = DrupalUtils.getFileFromEnv("DRUSH_HOME");
            if (!drushHome.isDirectory()) {
                throw new FileNotFoundException("Please set DRUSH_HOME correctly.");
            }
            String drushExecutable = drushHome.getAbsolutePath() + File.separator + "drush";
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(drushExecutable);
            commands.addAll(Arrays.asList(vars));
            return DrupalUtils.executeSystemCommand(commands, drupalHome);
        }
        catch (FileNotFoundException e) {
            throw new DrupalConfigException(e);
        }
    }

    public static String executeSystemCommand(List<String> command, File workingDir) throws EvaluationFailureException {
        logger.finest("Running system command: " + StringUtils.join(command, (char)' '));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        if (workingDir != null && workingDir.exists() && workingDir.isDirectory()) {
            processBuilder.directory(workingDir);
        } else {
            logger.info("Using current user directory to run system command.");
        }
        try {
            Process process = processBuilder.start();
            process.waitFor();
            if (process.exitValue() != 0) {
                logger.severe(DrupalUtils.getContent(new InputStreamReader(process.getErrorStream())));
                throw new EvaluationFailureException("Unexpected error executing system command: " + process.exitValue());
            }
            return DrupalUtils.getContent(new InputStreamReader(process.getInputStream()));
        }
        catch (IOException e) {
            throw new EvaluationFailureException(e);
        }
        catch (InterruptedException e) {
            throw new EvaluationFailureException(e);
        }
    }

    public static String getIdentifier(Class<?> classObject) {
        Identifier id = classObject.getAnnotation(Identifier.class);
        if (id != null) {
            return id.value();
        }
        return classObject.getSimpleName();
    }
}

