/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command;

import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.drupal.project.async_command.DrupalUtils;
import org.drupal.project.async_command.exception.DrupalRuntimeException;

public class EncryptedFieldAdapter {
    private static Logger logger = DrupalUtils.getPackageLogger();
    private final Method method;
    private final String secretkey;

    public EncryptedFieldAdapter(Method method) {
        this.method = method;
        this.secretkey = null;
    }

    public EncryptedFieldAdapter(Method method, String secretKey) {
        this.method = method;
        this.secretkey = secretKey;
    }

    public String readContent(String encrypted) {
        String original = null;
        switch (this.method) {
            case NONE: {
                original = encrypted;
                break;
            }
            case BASE64: {
                original = new String(Base64.decodeBase64((String)encrypted));
                break;
            }
            case MCRYPT: {
                if (this.secretkey == null) {
                    throw new DrupalRuntimeException("Need to set secretKey in order to decrypt MCRYPT message.");
                }
                original = DrupalUtils.evalPhp("echo rtrim(mcrypt_decrypt(MCRYPT_3DES,''{0}'',base64_decode(''{1}''),''ecb''),''\\0'');", this.secretkey, encrypted);
                original = original.trim();
            }
        }
        return original;
    }

    public Properties readSettings(String encrypted) {
        String original = this.readContent(encrypted);
        return DrupalUtils.loadProperties(original);
    }

    public static enum Method {
        NONE,
        BASE64,
        MCRYPT;

    }
}

