/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.drupal.project.async_command.AsyncCommand;
import org.drupal.project.async_command.CommandRecord;
import org.drupal.project.async_command.DrupalConnection;
import org.drupal.project.async_command.DrupalUtils;
import org.drupal.project.async_command.PingMe;
import org.drupal.project.async_command.exception.CommandParseException;

public class GenericDrupalApp
implements Runnable {
    private RunningMode runningMode;
    protected DrupalConnection drupalConnection;
    protected static Logger logger = DrupalUtils.getPackageLogger();
    protected Map<String, Class> acceptableCommandClass = new HashMap<String, Class>();

    public GenericDrupalApp(DrupalConnection drupalConnection) {
        assert (drupalConnection != null);
        this.runningMode = RunningMode.SERIAL;
        this.setDrupalConnection(drupalConnection);
        this.registerCommandClass(PingMe.class);
    }

    public void setRunningMode(RunningMode runningMode) {
        this.runningMode = runningMode;
    }

    protected void setDrupalConnection(DrupalConnection drupalConnection) {
        assert (drupalConnection != null);
        this.drupalConnection = drupalConnection;
    }

    public DrupalConnection getDrupalConnection() {
        return this.drupalConnection;
    }

    public String getIdentifier() {
        return DrupalUtils.getIdentifier(this.getClass());
    }

    AsyncCommand parseCommand(CommandRecord record) throws CommandParseException {
        if (this.acceptableCommandClass.containsKey(record.getCommand())) {
            Class commandClass = this.acceptableCommandClass.get(record.getCommand());
            try {
                Constructor constructor = commandClass.getConstructor(CommandRecord.class, GenericDrupalApp.class);
                return (AsyncCommand)constructor.newInstance(record, this);
            }
            catch (NoSuchMethodException e) {
                throw new CommandParseException("Cannot construct command object.", e);
            }
            catch (InvocationTargetException e) {
                throw new CommandParseException("Cannot construct command object.", e);
            }
            catch (InstantiationException e) {
                throw new CommandParseException("Cannot construct command object.", e);
            }
            catch (IllegalAccessException e) {
                throw new CommandParseException("Cannot construct command object.", e);
            }
        }
        throw new CommandParseException("Invalid command or not registered with the DrupalApp. Command: " + record.getCommand());
    }

    public void registerCommandClass(Class<? extends AsyncCommand> commandClass) {
        String id = DrupalUtils.getIdentifier(commandClass);
        this.acceptableCommandClass.put(id, commandClass);
    }

    @Override
    public void run() {
        assert (this.drupalConnection != null);
        this.drupalConnection.connect();
        switch (this.runningMode) {
            case FIRST: {
                throw new UnsupportedOperationException("PARALLEL running mode not supported yet.");
            }
            case SERIAL: {
                this.runSerial();
                break;
            }
            case PARALLEL: {
                throw new UnsupportedOperationException("PARALLEL running mode not supported yet.");
            }
            case NONSTOP: {
                throw new UnsupportedOperationException("NONSTOP running mode not supported yet.");
            }
        }
        this.drupalConnection.close();
        this.drupalConnection = null;
        logger.info("Running the DrupalApp is accomplished.");
    }

    protected void runSerial() {
        List<CommandRecord> records = this.drupalConnection.retrievePendingCommandRecord(this.getIdentifier());
        logger.info("Total number of commands to run: " + records.size());
        logger.fine("Sorting commands.");
        Collections.sort(records);
        for (CommandRecord record : records) {
            try {
                AsyncCommand command = this.parseCommand(record);
                logger.info("Executing command: " + record.getCommand());
                command.run();
            }
            catch (CommandParseException e) {
                logger.severe("Cannot parse command '" + record.getCommand() + "' for application '" + this.getIdentifier() + "'");
                e.printStackTrace();
                record.setStatus(AsyncCommand.Status.UNRECOGNIZED);
            }
            logger.info("Command finished running with status: " + record.getStatus().toString());
            record.persistResult();
        }
    }

    public static enum RunningMode {
        FIRST,
        SERIAL,
        PARALLEL,
        NONSTOP;

    }
}

