/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command.test;

import java.util.List;
import java.util.Properties;
import org.drupal.project.async_command.DrupalConnection;
import org.drupal.project.async_command.DrupalUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DrupalConnectionTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testBatchUpdateAndVariables() throws Exception {
        Properties prop = DrupalUtils.loadProperties(DrupalUtils.getConfigPropertiesFile());
        prop.setProperty("db_max_batch_size", "2");
        DrupalConnection conn = new DrupalConnection(prop);
        conn.connect();
        String s1 = DrupalUtils.evalPhp("echo serialize(2);");
        Object[][] params1 = new Object[][]{{"async_command_test1", "1".getBytes()}, {"async_command_test2", s1.getBytes()}, {"async_command_test3", "3".getBytes()}};
        conn.batch("INSERT INTO {variable}(name, value) VALUES(?, ?)", params1);
        long num1 = (Long)conn.queryValue("SELECT COUNT(*) FROM {variable} WHERE name LIKE 'async_command_test%'", new Object[0]);
        Assert.assertEquals((long)3L, (long)num1);
        int v1 = (Integer)conn.variableGet("async_command_test2");
        Assert.assertEquals((long)v1, (long)2L);
        conn.variableSet("async_command_test2", 100);
        v1 = (Integer)conn.variableGet("async_command_test2");
        Assert.assertEquals((long)v1, (long)100L);
        conn.variableSet("async_command_test2", "Hello");
        s1 = (String)conn.variableGet("async_command_test2");
        Assert.assertEquals((Object)s1, (Object)"Hello");
        String s2 = DrupalUtils.evalPhp("echo serialize('abc');");
        Object[][] params2 = new Object[][]{{s2.getBytes(), "async_command_test1"}};
        conn.batch("UPDATE {variable} SET value=? WHERE name=?", params2);
        String v2 = (String)conn.variableGet("async_command_test1");
        Assert.assertEquals((Object)v2, (Object)"abc");
        conn.close();
        prop = DrupalUtils.loadProperties(DrupalUtils.getConfigPropertiesFile());
        prop.setProperty("db_max_batch_size", "0");
        conn = new DrupalConnection(prop);
        conn.connect();
        Object[][] params3 = new Object[][]{{"async_command_test1"}, {"async_command_test2"}, {"async_command_test3"}};
        conn.batch("DELETE FROM {variable} WHERE name=?", params3);
        long num2 = (Long)conn.queryValue("SELECT COUNT(*) FROM {variable} WHERE name LIKE 'async_command_test%'", new Object[0]);
        Assert.assertEquals((long)num2, (long)0L);
        conn.close();
    }

    @Test
    public void testQuery() throws Exception {
        DrupalConnection conn = DrupalConnection.create();
        conn.connect();
        long uid = (Long)conn.queryValue("SELECT uid FROM {users} WHERE uid=1", new Object[0]);
        Assert.assertTrue((uid == 1L ? 1 : 0) != 0);
        Object result = conn.queryValue("SELECT uid FROM {users} WHERE uid=-1", new Object[0]);
        Assert.assertNull((Object)result);
        Object o = conn.queryValue("SELECT nid FROM {node} WHERE nid=0", new Object[0]);
        Assert.assertNull((Object)o);
        long i = (Long)conn.queryValue("SELECT COUNT(*) FROM {variable}", new Object[0]);
        Assert.assertTrue((i > 0L ? 1 : 0) != 0);
        List<Object[]> lst = conn.queryArray("SELECT uid, name FROM {users} WHERE uid < ?", 5);
        for (Object[] row : lst) {
            Assert.assertEquals((long)row.length, (long)2L);
            System.out.println("" + row[0] + " : " + row[1]);
        }
        conn.close();
    }

    @Test
    public void testAutoIncrement() throws Exception {
        DrupalConnection conn = DrupalConnection.create();
        conn.connect();
        long max = (Long)conn.queryValue("SELECT max(rid) FROM {role}", new Object[0]);
        long r1 = conn.insertAutoIncrement("INSERT INTO {role}(name, weight) VALUE(?, ?)", "test1", 0);
        Assert.assertTrue((r1 > max ? 1 : 0) != 0);
        long r2 = conn.insertAutoIncrement("INSERT INTO {role}(name, weight) VALUE(?, ?)", "test2", 0);
        Assert.assertTrue((r2 - r1 == 1L ? 1 : 0) != 0);
        Object[][] params = new Object[][]{{r1}, {r2}};
        conn.batch("DELETE FROM {role} WHERE rid=?", params);
        long r3 = (Long)conn.queryValue("SELECT max(rid) FROM {role}", new Object[0]);
        Assert.assertEquals((long)r3, (long)max);
        conn.close();
    }
}

