/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command.test;

import java.io.File;
import java.util.Properties;
import org.drupal.project.async_command.DefaultDrupalApp;
import org.drupal.project.async_command.DrupalUtils;
import org.drupal.project.async_command.EncryptedFieldAdapter;
import org.drupal.project.async_command.GenericDrupalApp;
import org.drupal.project.async_command.PingMe;
import org.junit.Assert;
import org.junit.Test;

public class DrupalUtilsTest {
    @Test
    public void testEvalPhp() throws Exception {
        String str = "Hello, world";
        Assert.assertTrue((boolean)DrupalUtils.evalPhp("echo \"{0}\";", str).equals(str));
        Assert.assertTrue((boolean)DrupalUtils.evalPhp("echo 1;").equals("1"));
    }

    @Test
    public void testDecryption() throws Exception {
        Properties config = DrupalUtils.loadProperties(DrupalUtils.getConfigPropertiesFile());
        String key = config.getProperty("mcrypt_secret_key");
        Assert.assertNotNull((Object)key);
        EncryptedFieldAdapter encset = new EncryptedFieldAdapter(EncryptedFieldAdapter.Method.MCRYPT, key);
        String orig = "abc=def";
        String enc = DrupalUtils.evalPhp("echo base64_encode(mcrypt_encrypt(MCRYPT_3DES, \"{0}\", \"{1}\", 'ecb'));", key, orig);
        Properties p = encset.readSettings(enc);
        Assert.assertTrue((boolean)p.getProperty("abc").trim().equals("def"));
    }

    @Test
    public void testReadSettingsFile() throws Exception {
        File settingsFile = DrupalUtils.getDrupalSettingsFile();
        System.out.println(settingsFile.getAbsolutePath());
        Properties config = DrupalUtils.convertSettingsToConfig(settingsFile);
        junit.framework.Assert.assertEquals((String)config.getProperty("database_type"), (String)"mysql");
        DrupalUtils.prepareConfig(config);
        junit.framework.Assert.assertEquals((String)config.getProperty("url"), (String)"jdbc:mysql://localhost/drupal7");
    }

    @Test
    public void testDrush() throws Exception {
        DrupalUtils.executeDrush("vset", "async_command_drush_test", "Hello", "--always-set");
        String output = DrupalUtils.executeDrush("vget", "async_command_drush_test");
        Assert.assertTrue((boolean)output.trim().endsWith("\"Hello\""));
        DrupalUtils.executeDrush("vdel", "async_command_drush_test", "--yes");
    }

    @Test
    public void testIdentifier() throws Exception {
        Assert.assertTrue((boolean)DrupalUtils.getIdentifier(DefaultDrupalApp.class).equals("default"));
        Assert.assertTrue((boolean)DrupalUtils.getIdentifier(GenericDrupalApp.class).equals("GenericDrupalApp"));
        Assert.assertTrue((boolean)DrupalUtils.getIdentifier(PingMe.class).equals("PingMe"));
    }
}

