/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.drupal.project.async_command.AsyncCommand;
import org.drupal.project.async_command.DrupalConnection;
import org.drupal.project.async_command.DrupalUtils;
import org.drupal.project.async_command.exception.DatabaseRuntimeException;

public class CommandRecord
implements Comparable<CommandRecord> {
    private final Long id;
    private final String app;
    private final String command;
    private final String description;
    private final Long uid;
    private final Long eid;
    private final Long created;
    private final byte[] input;
    private byte[] output;
    private Long id1;
    private Long id2;
    private Float number1;
    private Float number2;
    private Float number3;
    private Float number4;
    private String string1;
    private String string2;
    private String status;
    private String control;
    private String message;
    private Long weight;
    private Long start;
    private Long end;
    private Long checkpoint;
    private Float progress;
    private final DrupalConnection drupalConnection;

    public CommandRecord(Map<String, Object> row, DrupalConnection drupalConnection) {
        assert (row != null);
        this.drupalConnection = drupalConnection;
        this.id = DrupalUtils.getLong(row.get("id"));
        this.app = (String)row.get("app");
        this.command = (String)row.get("command");
        this.description = (String)row.get("description");
        this.uid = DrupalUtils.getLong(row.get("uid"));
        this.eid = DrupalUtils.getLong(row.get("eid"));
        this.created = DrupalUtils.getLong(row.get("created"));
        this.input = (byte[])row.get("input");
        this.output = (byte[])row.get("output");
        this.id1 = DrupalUtils.getLong(row.get("id1"));
        this.id2 = DrupalUtils.getLong(row.get("id2"));
        this.number1 = (Float)row.get("number1");
        this.number2 = (Float)row.get("number2");
        this.number3 = (Float)row.get("number3");
        this.number4 = (Float)row.get("number4");
        this.string1 = (String)row.get("string1");
        this.string2 = (String)row.get("string2");
        this.status = (String)row.get("status");
        this.control = (String)row.get("control");
        this.message = (String)row.get("message");
        this.weight = DrupalUtils.getLong(row.get("weight"));
        this.start = DrupalUtils.getLong(row.get("start"));
        this.end = DrupalUtils.getLong(row.get("end"));
        this.checkpoint = DrupalUtils.getLong(row.get("checkpoint"));
        this.progress = (Float)row.get("progress");
    }

    public void persistResult() {
        assert (this.drupalConnection != null && this.id != null && this.id > 0L);
        String sql = "UPDATE {async_command} SET output=?, id1=?, id2=?, number1=?, number2=?, number3=?, number4=?, string1=?, string2=?, status=?, control=?, message=?, weight=?, start=?, end=?, checkpoint=?, progress=? WHERE id=?";
        try {
            this.drupalConnection.update(sql, this.output, this.id1, this.id2, this.number1, this.number2, this.number3, this.number4, this.string1, this.string2, this.status, this.control, this.message, this.weight, this.start, this.end, this.checkpoint, this.progress, this.id);
        }
        catch (SQLException e) {
            AsyncCommand.logger.severe("Cannot update command record. Fatal error. Record id: " + this.id);
            throw new DatabaseRuntimeException(e);
        }
    }

    public void persistField(String fieldName, Object fieldValue) {
        assert (fieldName.equals("status") || fieldName.equals("control") || fieldName.equals("message") || fieldName.equals("weight") || fieldName.equals("start") || fieldName.equals("end") || fieldName.equals("checkpoint") || fieldName.equals("progress"));
        assert (this.drupalConnection != null);
        try {
            this.drupalConnection.update("UPDATE {async_command} SET " + fieldName + "=?", fieldValue);
        }
        catch (SQLException e) {
            AsyncCommand.logger.severe("Cannot update command record for field '" + fieldName + "'. Record id: " + this.id);
            throw new DatabaseRuntimeException(e);
        }
    }

    @Override
    public int compareTo(CommandRecord o) {
        int compareWeight = this.weight.compareTo(o.weight);
        if (compareWeight != 0) {
            return compareWeight;
        }
        int compareCreated = this.created.compareTo(o.created);
        if (compareCreated != 0) {
            return compareCreated;
        }
        return this.id.compareTo(o.id);
    }

    public static CommandRecord createDbRecord(Map<String, Object> fields, DrupalConnection drupalConnection) {
        long id = drupalConnection.insertCommandRecord(fields);
        return drupalConnection.retrieveCommandRecord(id);
    }

    public static CommandRecord createAdHocRecord(Map<String, Object> fields) {
        if (fields == null) {
            fields = new HashMap<String, Object>();
        }
        return new CommandRecord(fields, null);
    }

    public String getCommand() {
        return this.command;
    }

    public void setStatus(AsyncCommand.Status status) {
        this.status = status.toString();
        assert (this.status.length() == 4);
    }

    public AsyncCommand.Status getStatus() {
        if (this.status != null) {
            return AsyncCommand.Status.parse(this.status);
        }
        return null;
    }

    public Long getId() {
        return this.id;
    }

    public String getApp() {
        return this.app;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getUid() {
        return this.uid;
    }

    public Long getEid() {
        return this.eid;
    }

    public Long getCreated() {
        return this.created;
    }

    public byte[] getInput() {
        return this.input;
    }

    public byte[] getOutput() {
        return this.output;
    }

    public Long getId1() {
        return this.id1;
    }

    public Long getId2() {
        return this.id2;
    }

    public Float getNumber1() {
        return this.number1;
    }

    public Float getNumber2() {
        return this.number2;
    }

    public Float getNumber3() {
        return this.number3;
    }

    public Float getNumber4() {
        return this.number4;
    }

    public String getString1() {
        return this.string1;
    }

    public String getString2() {
        return this.string2;
    }

    public String getControl() {
        return this.control;
    }

    public String getMessage() {
        return this.message;
    }

    public Long getWeight() {
        return this.weight;
    }

    public Long getStart() {
        return this.start;
    }

    public Long getEnd() {
        return this.end;
    }

    public Long getCheckpoint() {
        return this.checkpoint;
    }

    public Float getProgress() {
        return this.progress;
    }

    public void setOutput(byte[] output) {
        this.output = output;
    }

    public void setId1(Long id1) {
        this.id1 = id1;
    }

    public void setId2(Long id2) {
        this.id2 = id2;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    public void setNumber3(Float number3) {
        this.number3 = number3;
    }

    public void setNumber4(Float number4) {
        this.number4 = number4;
    }

    public void setString1(String string1) {
        this.string1 = string1;
    }

    public void setString2(String string2) {
        this.string2 = string2;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setControl(String control) {
        this.control = control;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setWeight(Long weight) {
        this.weight = weight;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public void setCheckpoint(Long checkpoint) {
        this.checkpoint = checkpoint;
    }

    public void setProgress(Float progress) {
        this.progress = progress;
    }
}

