/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command;

import java.io.File;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.drupal.project.async_command.AsyncCommand;
import org.drupal.project.async_command.CommandRecord;
import org.drupal.project.async_command.DrupalUtils;
import org.drupal.project.async_command.exception.ConfigLoadingException;
import org.drupal.project.async_command.exception.DatabaseRuntimeException;
import org.drupal.project.async_command.exception.DrupalAppException;

public class DrupalConnection {
    protected Properties config;
    protected static Logger logger = DrupalUtils.getPackageLogger();
    protected BasicDataSource dataSource;
    private String dbPrefix;
    private int maxBatchSize;
    private int drupalVersion;
    private DatabaseType databaseType;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public static DrupalConnection create() {
        DrupalConnection drupalConnection;
        try {
            File configFile = DrupalUtils.getConfigPropertiesFile();
            drupalConnection = new DrupalConnection(configFile);
        }
        catch (FileNotFoundException e) {
            logger.warning("Cannot find config.properties file. Try settings.php now.");
            try {
                File settingsFile = DrupalUtils.getDrupalSettingsFile();
                Properties config = DrupalUtils.convertSettingsToConfig(settingsFile);
                drupalConnection = new DrupalConnection(config);
            }
            catch (FileNotFoundException e1) {
                throw new ConfigLoadingException("Cannot find either config.properties or settings.php to create DrupalConnection object.");
            }
        }
        return drupalConnection;
    }

    public DrupalConnection(Properties config) {
        String p;
        DrupalUtils.prepareConfig(config);
        this.config = config;
        this.drupalVersion = Integer.parseInt(config.getProperty("drupal_version"));
        String url = this.config.getProperty("url");
        this.databaseType = url.startsWith("jdbc:mysql") ? DatabaseType.MYSQL : (url.startsWith("jdbc:postgresql") ? DatabaseType.POSTGRESQL : DatabaseType.UNKNOWN);
        if (config.containsKey("db_prefix")) {
            String p2 = config.getProperty("db_prefix").trim();
            if (p2.length() != 0) {
                this.dbPrefix = p2;
            }
        } else if (config.containsKey("prefix") && (p = config.getProperty("prefix").trim()).length() != 0) {
            this.dbPrefix = p;
        }
        int n = this.maxBatchSize = config.containsKey("db_max_batch_size") ? Integer.parseInt(config.getProperty("db_max_batch_size")) : 0;
        if (this.maxBatchSize > 0) {
            logger.fine("Batch SQL size: " + this.maxBatchSize);
        }
    }

    public DrupalConnection(String configString) {
        this(DrupalUtils.loadProperties(configString));
    }

    public DrupalConnection(File configFile) {
        this(DrupalUtils.loadProperties(configFile));
    }

    public void connect() {
        this.connect(false);
    }

    public void connect(boolean reconnect) {
        if (this.dataSource != null && !reconnect) {
            return;
        }
        try {
            this.dataSource = (BasicDataSource)BasicDataSourceFactory.createDataSource((Properties)this.config);
        }
        catch (Exception e) {
            logger.severe("Error initializing DataSource for Drupal database connection.");
            throw new DrupalAppException(e);
        }
        this.testConnection();
    }

    public void testConnection() {
        this.assertConnection();
        try {
            Connection conn = this.dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            logger.info("Database connection successful: " + metaData.getDatabaseProductName() + metaData.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            logger.severe("Cannot connect to Drupal database during initialization. Please make sure the Drupal database is up and running and the database access is correct.");
            throw new DatabaseRuntimeException(e);
        }
    }

    public void close() {
        try {
            this.dataSource.close();
        }
        catch (SQLException e) {
            logger.severe("Cannot close Drupal connection.");
            throw new DatabaseRuntimeException(e);
        }
    }

    public boolean checkConnection() {
        return this.dataSource != null && !this.dataSource.isClosed();
    }

    private void assertConnection() {
        if (!this.checkConnection()) {
            throw new DrupalAppException("Drupal database connection not initialized or closed. Please check whether the Drupal database is up and running and the network is fine.");
        }
    }

    public String d(String sql) {
        String newSql = this.dbPrefix != null ? sql.replaceAll("\\{(.+?)\\}", this.dbPrefix + "_" + "$1") : sql.replaceAll("\\{(.+?)\\}", "$1");
        logger.fine(newSql);
        return newSql;
    }

    public List<Map<String, Object>> query(String sql, Object ... params) throws SQLException {
        this.assertConnection();
        QueryRunner q = new QueryRunner((DataSource)this.dataSource);
        List result = (List)q.query(this.d(sql), (ResultSetHandler)new MapListHandler(), params);
        return result;
    }

    public Object queryValue(String sql, Object ... params) throws SQLException {
        this.assertConnection();
        QueryRunner q = new QueryRunner((DataSource)this.dataSource);
        Object result = q.query(this.d(sql), (ResultSetHandler)new ScalarHandler(), params);
        return result;
    }

    public List<Object[]> queryArray(String sql, Object ... params) throws SQLException {
        this.assertConnection();
        QueryRunner q = new QueryRunner((DataSource)this.dataSource);
        List result = (List)q.query(this.d(sql), (ResultSetHandler)new ArrayListHandler(), params);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, Object ... params) throws SQLException {
        this.assertConnection();
        logger.finest("SQL UPDATE: " + sql);
        QueryRunner q = new QueryRunner();
        Connection conn = this.dataSource.getConnection();
        try {
            int num = q.update(conn, this.d(sql), params);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            int n = num;
            return n;
        }
        finally {
            DbUtils.close((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertAutoIncrement(String sql, Object ... params) throws SQLException {
        this.assertConnection();
        assert (sql.toLowerCase().startsWith("insert"));
        String preparedSql = this.d(sql);
        logger.finest("SQL INSERT: " + sql);
        Connection conn = this.dataSource.getConnection();
        PreparedStatement stmt = conn.prepareStatement(preparedSql, 1);
        QueryRunner q = new QueryRunner();
        try {
            q.fillStatement(stmt, params);
            stmt.executeUpdate();
            ResultSet rs = stmt.getGeneratedKeys();
            rs.next();
            long id = rs.getLong(1);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            long l = id;
            return l;
        }
        finally {
            DbUtils.close((Statement)stmt);
            DbUtils.close((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batch(String sql, Object[][] params) throws SQLException {
        this.assertConnection();
        logger.finest("SQL BATCH: " + sql);
        logger.finest("Number of rows in batch: " + params.length);
        Connection conn = this.dataSource.getConnection();
        try {
            int[] num = this.batch(conn, sql, params);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            int[] nArray = num;
            return nArray;
        }
        finally {
            DbUtils.close((Connection)conn);
        }
    }

    private int[] batch(Connection conn, String sql, Object[][] params) throws SQLException {
        QueryRunner q = new QueryRunner();
        String processedSql = this.d(sql);
        if (this.maxBatchSize > 0) {
            int start = 0;
            int end = 0;
            int[] num = new int[params.length];
            do {
                if ((end += this.maxBatchSize) > params.length) {
                    end = params.length;
                }
                logger.finest("Database batch processing: " + start + " to " + end);
                int[] batchNum = q.batch(conn, processedSql, (Object[][])Arrays.copyOfRange(params, start, end));
                for (int count = 0; count < batchNum.length; ++count) {
                    num[start + count] = batchNum[count];
                }
                start = end;
            } while (end < params.length);
            return num;
        }
        logger.finest("Batch processing all.");
        return q.batch(conn, processedSql, params);
    }

    public Object variableGet(String varName) {
        this.assertConnection();
        assert (varName != null);
        try {
            Object serializedBytes = this.queryValue("SELECT value FROM {variable} WHERE name=?", varName);
            if (serializedBytes == null) {
                return null;
            }
            String serialized = DrupalUtils.convertBlobToString(serializedBytes);
            return DrupalUtils.unserializePhp(serialized);
        }
        catch (SQLException e) {
            throw new DatabaseRuntimeException(e);
        }
    }

    public void variableSet(String varName, Object varValue) {
        this.assertConnection();
        assert (varName != null && varValue != null);
        String serialized = String.class.isInstance(varValue) ? DrupalUtils.evalPhp("echo serialize(''{0}'');", varValue) : DrupalUtils.evalPhp("echo serialize({0});", varValue);
        byte[] serializedBytes = serialized.getBytes();
        try {
            this.update("UPDATE {variable} SET value=? WHERE name=?", serializedBytes, varName);
        }
        catch (SQLException e) {
            throw new DatabaseRuntimeException(e);
        }
    }

    public List<CommandRecord> retrieveAnyCommandRecord(String sqlWhere) {
        List<Map<String, Object>> rows;
        this.assertConnection();
        ArrayList<CommandRecord> records = new ArrayList<CommandRecord>();
        String sql = "SELECT * FROM {async_command}";
        if (sqlWhere != null) {
            assert (sqlWhere.toUpperCase().startsWith("WHERE"));
            sql = sql + " " + sqlWhere;
        }
        try {
            rows = this.query(sql, new Object[0]);
        }
        catch (SQLException e) {
            throw new DatabaseRuntimeException(e);
        }
        for (Map<String, Object> row : rows) {
            CommandRecord record = new CommandRecord(row, this);
            records.add(record);
        }
        return records;
    }

    public List<CommandRecord> retrievePendingCommandRecord(String appName) {
        assert (appName != null);
        logger.finest("Retrieving pending commands for " + appName);
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append("WHERE app='").append(appName).append("' AND (status IS NULL OR status='").append(AsyncCommand.Status.PENDING.toString()).append("')");
        return this.retrieveAnyCommandRecord(sqlWhere.toString());
    }

    public long insertCommandRecord(Map<String, Object> fields) {
        throw new UnsupportedOperationException();
    }

    public CommandRecord retrieveCommandRecord(long id) {
        try {
            List<Map<String, Object>> rows = this.query("SELECT * FROM {async_command} WHERE id = ?", id);
            assert (rows.size() == 1);
            return new CommandRecord(rows.get(0), this);
        }
        catch (SQLException e) {
            throw new DatabaseRuntimeException(e);
        }
    }

    public Connection getConnection() throws SQLException {
        this.assertConnection();
        return this.dataSource.getConnection();
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public String getEncryptedFieldSecretKey() {
        return this.config.getProperty("mcrypt_secret_key", null);
    }

    public static enum DatabaseType {
        MYSQL,
        POSTGRESQL,
        UNKNOWN;

    }
}

