/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.drupal.project.async_command.AsyncCommand;
import org.drupal.project.async_command.CommandRecord;
import org.drupal.project.async_command.DrupalConnection;
import org.drupal.project.async_command.DrupalUtils;
import org.drupal.project.async_command.PingMe;
import org.drupal.project.async_command.exception.CommandExecutionException;
import org.drupal.project.async_command.exception.CommandParseException;
import org.drupal.project.async_command.exception.DrupalAppException;

public class GenericDrupalApp
implements Runnable {
    private RunningMode runningMode = RunningMode.SERIAL;
    protected DrupalConnection drupalConnection;
    protected Properties config;
    protected static Logger logger = DrupalUtils.getPackageLogger();
    protected ExecutorService executor = Executors.newSingleThreadExecutor();
    protected Map<String, Class> acceptableCommandClass = new HashMap<String, Class>();

    public GenericDrupalApp(DrupalConnection drupalConnection) {
        logger.fine("Constructor called for GenericDrupalApp");
        assert (drupalConnection != null);
        this.setDrupalConnection(drupalConnection);
        this.config = drupalConnection.config;
        this.registerCommandClass(PingMe.class);
    }

    protected GenericDrupalApp() {
        logger.fine("Default constructor called for GenericDrupalApp. Manually set DrupalConnection required.");
    }

    public void setRunningMode(RunningMode runningMode) {
        this.runningMode = runningMode;
    }

    protected void setDrupalConnection(DrupalConnection drupalConnection) {
        assert (drupalConnection != null);
        this.drupalConnection = drupalConnection;
    }

    public DrupalConnection getDrupalConnection() {
        return this.drupalConnection;
    }

    public String getIdentifier() {
        return DrupalUtils.getIdentifier(this.getClass());
    }

    AsyncCommand parseCommand(CommandRecord record) throws CommandParseException {
        if (this.acceptableCommandClass.containsKey(record.getCommand())) {
            Class commandClass = this.acceptableCommandClass.get(record.getCommand());
            try {
                Constructor constructor = commandClass.getConstructor(CommandRecord.class, GenericDrupalApp.class);
                return (AsyncCommand)constructor.newInstance(record, this);
            }
            catch (NoSuchMethodException e) {
                throw new DrupalAppException(e);
            }
            catch (InvocationTargetException e) {
                throw new DrupalAppException(e);
            }
            catch (InstantiationException e) {
                throw new DrupalAppException(e);
            }
            catch (IllegalAccessException e) {
                throw new DrupalAppException(e);
            }
        }
        throw new CommandParseException("Invalid command or not registered with the DrupalApp. Command: " + record.getCommand());
    }

    public void registerCommandClass(Class<? extends AsyncCommand> commandClass) {
        String id = DrupalUtils.getIdentifier(commandClass);
        this.acceptableCommandClass.put(id, commandClass);
    }

    public void registerCommandClass(String identifier, Class commandClass) {
        assert (AsyncCommand.class.isAssignableFrom(commandClass));
        this.acceptableCommandClass.put(identifier, commandClass);
    }

    @Override
    public void run() {
        assert (this.drupalConnection != null);
        this.drupalConnection.connect();
        switch (this.runningMode) {
            case FIRST: {
                throw new UnsupportedOperationException("PARALLEL running mode not supported yet.");
            }
            case SERIAL: {
                this.runSerial();
                break;
            }
            case PARALLEL: {
                this.runParallel();
                break;
            }
            case NONSTOP: {
                throw new UnsupportedOperationException("NONSTOP running mode not supported yet.");
            }
        }
        logger.info("Shutdown parallel executor.");
        this.executor.shutdown();
        this.drupalConnection.close();
        this.drupalConnection = null;
        logger.info("Running the DrupalApp is accomplished.");
    }

    protected void handleException(CommandRecord record, Throwable exception) {
        if (CommandParseException.class.isInstance(exception)) {
            record.setStatus(AsyncCommand.Status.UNRECOGNIZED);
            record.setMessage(exception.getMessage());
        } else if (CommandExecutionException.class.isInstance(exception)) {
            logger.severe("Cannot run command '" + record.getCommand() + "' for application '" + this.getIdentifier() + "'. Error message: " + exception.getMessage());
            if (record.getStatus() == null) {
                record.setStatus(AsyncCommand.Status.FAILURE);
            }
            if (record.getMessage() == null) {
                record.setMessage(exception.getMessage());
            }
        } else if (DrupalAppException.class.isInstance(exception)) {
            logger.severe("Unexpected error happens for command: " + record.getCommand());
            record.setStatus(AsyncCommand.Status.FAILURE);
            record.setMessage(exception.getMessage());
        } else {
            logger.severe("System error or programming bug.");
            record.setStatus(AsyncCommand.Status.INTERNAL_ERROR);
            record.setMessage("System error or programming bug. See execution log for more details. Error type: " + exception.getClass().getName());
        }
        exception.printStackTrace();
    }

    protected void runSerial() {
        List<CommandRecord> records = this.drupalConnection.retrievePendingCommandRecord(this.getIdentifier());
        logger.info("Total number of commands to run: " + records.size());
        logger.fine("Sorting commands.");
        Collections.sort(records);
        for (CommandRecord record : records) {
            AsyncCommand command = null;
            try {
                command = this.parseCommand(record);
                logger.info("Executing command: " + record.getCommand());
                command.run();
            }
            catch (Throwable e) {
                this.handleException(record, e);
            }
            if (record.getEnd() == null) {
                record.setEnd(DrupalUtils.getLocalUnixTimestamp());
            }
            logger.info("Command finished running with status: " + record.getStatus().toString());
            record.persistResult();
        }
    }

    protected void runParallel() {
        int coreThreadNum = Integer.parseInt(this.config.getProperty("thread_core_number", "2"));
        int maxThreadNum = Integer.parseInt(this.config.getProperty("thread_max_number", "2"));
        if (maxThreadNum < coreThreadNum) {
            logger.warning("thread_max_number cannot be smaller than thread_core_number.");
            maxThreadNum = coreThreadNum;
        }
        this.executor = new ThreadPoolExecutor(coreThreadNum, maxThreadNum, 0L, TimeUnit.SECONDS, new PriorityBlockingQueue(), (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy()){

            @Override
            protected void afterExecute(Runnable runnable, Throwable throwable) {
                super.afterExecute(runnable, throwable);
                if (throwable != null) {
                    CommandRecord record;
                    block6: {
                        assert (runnable instanceof Future);
                        record = null;
                        try {
                            record = (CommandRecord)((Future)((Object)runnable)).get();
                        }
                        catch (InterruptedException e) {
                            assert (false);
                        }
                        catch (ExecutionException e) {
                            if ($assertionsDisabled) break block6;
                            throw new AssertionError();
                        }
                    }
                    GenericDrupalApp.this.handleException(record, throwable);
                }
            }
        };
        List<CommandRecord> records = this.drupalConnection.retrievePendingCommandRecord(this.getIdentifier());
        ArrayList<Future<CommandRecord>> futuresList = new ArrayList<Future<CommandRecord>>();
        HashMap<Future<CommandRecord>, CommandRecord> futuresMap = new HashMap<Future<CommandRecord>, CommandRecord>();
        for (CommandRecord commandRecord : records) {
            try {
                AsyncCommand command = this.parseCommand(commandRecord);
                Future<CommandRecord> future = this.executor.submit(command, commandRecord);
                futuresList.add(future);
                futuresMap.put(future, commandRecord);
            }
            catch (CommandParseException e) {
                commandRecord.setStatus(AsyncCommand.Status.UNRECOGNIZED);
                commandRecord.setMessage(e.getMessage());
                commandRecord.persistResult();
                e.printStackTrace();
            }
        }
        logger.info("Total number of commands to run in parallel: " + futuresList.size());
        for (Future future : futuresList) {
            CommandRecord record = null;
            try {
                record = (CommandRecord)future.get();
            }
            catch (Throwable e) {
                if (record == null) {
                    record = (CommandRecord)futuresMap.get(future);
                }
                this.handleException(record, e);
            }
            record.persistResult();
        }
    }

    public static enum RunningMode {
        FIRST,
        SERIAL,
        PARALLEL,
        NONSTOP;

    }
}

