/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command;

import org.drupal.project.async_command.AsyncCommand;
import org.drupal.project.async_command.CommandRecord;
import org.drupal.project.async_command.DrupalUtils;
import org.drupal.project.async_command.GenericDrupalApp;

public class PingMe
extends AsyncCommand {
    private String pingMessage;
    private String pongMessage;
    private Long sleepTime;

    public PingMe(CommandRecord record, GenericDrupalApp drupalApp) {
        super(record, drupalApp);
        this.initialize(record.getString1(), DrupalUtils.getLong(record.getNumber1()));
    }

    public void initialize(String pingMessage, Long sleepTime) {
        this.pingMessage = pingMessage;
        this.sleepTime = sleepTime;
    }

    @Override
    public void run() {
        this.record.setStart(DrupalUtils.getLocalUnixTimestamp());
        if (this.sleepTime != null) {
            try {
                logger.info("PingMe sleeps for " + this.sleepTime + " milliseconds.");
                Thread.currentThread();
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                this.record.setStatus(AsyncCommand.Status.FAILURE);
                this.record.setMessage("Interrupted while PingMe sleeps.");
                this.record.setEnd(DrupalUtils.getLocalUnixTimestamp());
                return;
            }
        }
        this.pongMessage = this.pingMessage != null ? "Pong with message: " + this.pingMessage : "Pong.";
        this.record.setStatus(AsyncCommand.Status.SUCCESS);
        this.record.setMessage(this.pongMessage);
        this.record.setEnd(DrupalUtils.getLocalUnixTimestamp());
    }
}

