/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command.deprecated;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.drupal.project.async_command.DrupalConnection;
import org.drupal.project.async_command.DrupalUtils;
import org.drupal.project.async_command.EncryptedFieldAdapter;
import org.drupal.project.async_command.deprecated.CommandDeprecated;
import org.drupal.project.async_command.deprecated.EvaluationFailureException;
import org.drupal.project.async_command.deprecated.Result;
import org.drupal.project.async_command.exception.DrupalAppException;

@Deprecated
public abstract class AbstractDrupalAppDeprecated {
    private final String VERSION = "7_1_0";
    protected DataSource dataSource;
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    protected DrupalConnection drupalConnection;
    protected RunningMode runningMode = RunningMode.ONCE;
    protected Properties config = new Properties();
    private String configFilePath = this.getDefaultConfigFilePath();
    private String dbPrefix;
    protected int maxBatchSize;

    public abstract String identifier();

    public void runApp() {
        this.logger.info("Initialize Drupal connection.");
        this.initDrupalConnection();
        this.logger.info("Preparing Drupal applet.");
        this.prepareApp();
        List<Map<String, Object>> commandList = null;
        try {
            commandList = this.query("SELECT id, command, uid, eid, created FROM {async_command} WHERE app=? AND status IS NULL ORDER BY created", this.identifier());
        }
        catch (SQLException e) {
            this.logger.severe("Cannot query async_command table.");
            throw new DrupalAppException(e);
        }
        this.logger.info("Total commands to be executed: " + commandList.size());
        for (Map<String, Object> commandRecord : commandList) {
            int id = ((Long)commandRecord.get("id")).intValue();
            String command = (String)commandRecord.get("command");
            this.logger.info("Running async_command: " + command);
            Result result = null;
            try {
                this.prepareCommand((Integer)commandRecord.get("uid"), (Integer)commandRecord.get("eid"), (Integer)commandRecord.get("created"), command);
                result = this.runCommand(command);
            }
            catch (EvaluationFailureException e) {
                this.updateRecord(id, false, "Command evaluation error. See script log for details. Error: " + e.getMessage());
                e.printStackTrace();
                continue;
            }
            catch (DrupalAppException e) {
                this.updateRecord(id, false, e.getMessage());
                e.printStackTrace();
                continue;
            }
            this.updateRecord(id, result.getStatus(), result.getMessage());
            this.logger.info("Result: " + result.getStatus());
        }
    }

    public List<CommandDeprecated> retrievePendingCommand(String app) {
        assert (this.drupalConnection != null);
        ArrayList<CommandDeprecated> commandList = new ArrayList<CommandDeprecated>();
        List<Map<String, Object>> dbResults = null;
        try {
            dbResults = this.query("SELECT id, command, uid, eid, created FROM {async_command} WHERE app=? AND status IS NULL ORDER BY created", this.identifier());
        }
        catch (SQLException e) {
            this.logger.severe("Cannot query async_command table.");
            throw new DrupalAppException(e);
        }
        for (Map<String, Object> commandRecord : dbResults) {
            CommandDeprecated command = new CommandDeprecated(((Long)commandRecord.get("id")).intValue(), (String)commandRecord.get("command"), (Integer)commandRecord.get("uid"), (Integer)commandRecord.get("eid"), (Integer)commandRecord.get("created"));
            commandList.add(command);
        }
        return commandList;
    }

    protected void prepareApp() {
    }

    protected Result runCommand(String command) throws EvaluationFailureException {
        try {
            Interpreter interpreter = new Interpreter();
            interpreter.set("app", (Object)this);
            Result result = (Result)interpreter.eval("app." + command);
            return result;
        }
        catch (EvalError e) {
            this.logger.severe("Cannot execute the command: " + command);
            throw new EvaluationFailureException(e);
        }
        catch (ClassCastException e) {
            this.logger.severe("The command should return a Result object.");
            throw new EvaluationFailureException(e);
        }
    }

    protected void prepareCommand(int uid, int eid, int created, String command) {
    }

    protected void updateRecord(int id, boolean status, String message) {
        long changed = new Date().getTime() / 1000L;
        try {
            this.update("UPDATE {async_command} SET status=?, message=?, changed=? WHERE id=?", status, message, changed, id);
        }
        catch (SQLException e) {
            this.logger.severe("Cannot update status in async_command.");
            throw new DrupalAppException(e);
        }
    }

    public Result pingMe() {
        return new Result(true, "Ping successful.");
    }

    @Deprecated
    public void initDrupalConnection() {
        block6: {
            if (this.drupalConnection != null) {
                this.logger.warning("Drupal connection exists already. Check your code and make sure things are OK.");
                return;
            }
            if (!this.config.containsKey("username") && !this.config.containsKey("password")) {
                try {
                    File configFile = new File(this.configFilePath);
                    File settingsPhpFile = this.getDefaultSettingsPhpFile();
                    if (configFile.exists()) {
                        FileReader configReader = new FileReader(configFile);
                        this.config.load(configReader);
                        break block6;
                    }
                    if (settingsPhpFile.exists()) {
                        this.logger.info("Fallback using Drupal setting.php file.");
                        this.loadSettingsPhp(settingsPhpFile);
                        break block6;
                    }
                    throw new DrupalAppException("Database configuration file " + this.configFilePath + " doesn't exists, and cannot find settings.php either. Please see documentation on how to configure the module.");
                }
                catch (IOException e) {
                    this.logger.severe("Error reading configuration file.");
                    throw new DrupalAppException(e);
                }
            }
        }
        this.drupalConnection = new DrupalConnection(this.config);
        this.drupalConnection.connect();
    }

    @Deprecated
    public void initConfig(String configString) {
        StringReader configReader = new StringReader(configString);
        try {
            this.config.load(configReader);
        }
        catch (IOException e) {
            throw new DrupalAppException("Cannot read config string.");
        }
    }

    @Deprecated
    protected File getDefaultSettingsPhpFile() {
        try {
            return DrupalUtils.getDrupalSettingsFile();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new DrupalAppException(e);
        }
    }

    @Deprecated
    public void testConnection() {
        this.initDrupalConnection();
        try {
            Connection conn = this.dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            this.logger.info("Database connection successful: " + metaData.getDatabaseProductName() + metaData.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            this.logger.severe("SQL error during testing connection.");
            throw new DrupalAppException(e);
        }
    }

    @Deprecated
    private String getDefaultConfigFilePath() {
        try {
            return DrupalUtils.getConfigPropertiesFile().toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new DrupalAppException(e);
        }
    }

    @Deprecated
    protected String d(String sql) {
        return this.drupalConnection.d(sql);
    }

    @Deprecated
    protected List<Map<String, Object>> query(String sql, Object ... params) throws SQLException {
        return this.drupalConnection.query(sql, params);
    }

    @Deprecated
    protected Object queryValue(String sql, Object ... params) throws SQLException {
        return this.drupalConnection.queryValue(sql, params);
    }

    @Deprecated
    protected int update(String sql, Object ... params) throws SQLException {
        return this.drupalConnection.update(sql, params);
    }

    @Deprecated
    protected int[] batch(String sql, Object[][] params) throws SQLException {
        return this.drupalConnection.batch(sql, params);
    }

    public void handleCLI(String[] args) {
        this.logger.info("DrupalApp VERSION: 7_1_0");
        Options options = this.buildOptions();
        PosixParser parser = new PosixParser();
        CommandLine command = null;
        try {
            command = parser.parse(options, args);
        }
        catch (ParseException exp) {
            this.logger.severe("Cannot parse parameters. Please use -h to see help. Error message: " + exp.getMessage());
            return;
        }
        this.handleCommandSettings(command);
        this.handleCommandExecutables(command);
    }

    private void handleCommandExecutables(CommandLine command) {
        if (command.hasOption('h')) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Drupal application -- " + this.identifier(), this.buildOptions());
        } else if (command.hasOption('t')) {
            this.testConnection();
        } else if (command.hasOption('e')) {
            this.initDrupalConnection();
            this.prepareApp();
            String evalStr = command.getOptionValue('e');
            try {
                Result result = this.runCommand(evalStr);
                String successMsg = result.getStatus() ? "succeeds" : "fails";
                this.logger.info("Running " + successMsg + ". Message: " + result.getMessage());
            }
            catch (EvaluationFailureException e) {
                this.logger.severe("Cannot evaluate script from command line.");
                throw new DrupalAppException(e);
            }
        } else {
            this.runApp();
        }
    }

    private void handleCommandSettings(CommandLine command) {
        if (command.hasOption('c')) {
            this.configFilePath = command.getOptionValue('c');
            this.logger.info("Set configuration file as: " + this.configFilePath);
        } else {
            this.configFilePath = this.getDefaultConfigFilePath();
        }
        if (command.hasOption('r')) {
            String rm = command.getOptionValue('r');
            if (rm.equals("once")) {
                this.runningMode = RunningMode.ONCE;
            } else {
                if (rm.equals("continuous")) {
                    throw new UnsupportedOperationException();
                }
                if (rm.equals("listening")) {
                    throw new UnsupportedOperationException();
                }
                this.logger.severe("Cannot parse parameters for -r. Please use -h to see help. Use default running mode.");
            }
        }
    }

    private Options buildOptions() {
        Options options = new Options();
        options.addOption("c", true, "database configuration file");
        options.addOption("r", true, "program running mode: 'once' (default), 'continuous', or 'listening'");
        options.addOption("h", "help", false, "print this message");
        options.addOption("t", "test", false, "test connection to Drupal database");
        options.addOption("e", "eval", true, "evaluate a method call directly");
        return options;
    }

    public void run(String[] args) {
        this.handleCLI(args);
    }

    @Deprecated
    protected Properties readEncryptedSettingsField(String value, EncryptionMethod encryptionMethod) {
        EncryptedFieldAdapter.Method method;
        switch (encryptionMethod) {
            case BASE64: {
                method = EncryptedFieldAdapter.Method.BASE64;
                break;
            }
            case MCRYPT: {
                method = EncryptedFieldAdapter.Method.MCRYPT;
                break;
            }
            default: {
                method = EncryptedFieldAdapter.Method.NONE;
            }
        }
        EncryptedFieldAdapter ensetAdapter = new EncryptedFieldAdapter(method, this.config.getProperty("mcrypt_secret_key"));
        return ensetAdapter.readSettings(value);
    }

    @Deprecated
    protected Properties readEncryptedSettingsField(String value) {
        return this.readEncryptedSettingsField(value, EncryptionMethod.MCRYPT);
    }

    @Deprecated
    protected void loadSettingsPhp(File settingsPhp) throws IOException {
        Properties config = DrupalUtils.convertSettingsToConfig(settingsPhp);
        DrupalUtils.prepareConfig(config);
        this.config.putAll((Map<?, ?>)config);
    }

    @Deprecated
    protected String evalPhp(String pattern, Object ... params) {
        return DrupalUtils.evalPhp(pattern, params);
    }

    @Deprecated
    protected String evalPhp(String phpCode) {
        return DrupalUtils.evalPhp(phpCode);
    }

    @Deprecated
    protected String getReaderContent(Reader input) throws IOException {
        return DrupalUtils.getContent(input);
    }

    @Deprecated
    protected Map<String, Object> unserializePhpArray(String serialized) {
        return DrupalUtils.unserializePhpArray(serialized);
    }

    @Deprecated
    protected String convertBlobValueToString(Object blobValue) {
        return DrupalUtils.convertBlobToString(blobValue);
    }

    @Deprecated
    protected Object drupalVariableGet(String varName) {
        return this.drupalConnection.variableGet(varName);
    }

    @Deprecated
    protected void drupalVariableSet(String varName, String varValue) {
        this.drupalConnection.variableSet(varName, varValue);
    }

    @Deprecated
    public static enum EncryptionMethod {
        NONE,
        BASE64,
        MCRYPT;

    }

    public static enum RunningMode {
        ONCE,
        CONTINUOUS,
        LISTENING,
        FIRST;

    }
}

