/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command.deprecated;

import java.util.concurrent.ThreadFactory;
import org.drupal.project.async_command.AsyncCommand;
import org.drupal.project.async_command.DrupalUtils;

public class CommandThreadFactory
implements ThreadFactory {
    private ThreadGroup defaultThreadGroup = new ThreadGroup("CommandThreadGroup");
    private final int WEIGHT_LOWER_BOUND = -1000;
    private final int WEIGHT_UPPER_BOUND = 1000;

    @Override
    public Thread newThread(Runnable r) {
        assert (r.getClass().isAssignableFrom(AsyncCommand.class)) : "CommandThreadFactory can only creates AsyncCommand runnables.";
        AsyncCommand command = (AsyncCommand)r;
        Thread thread = new Thread(this.defaultThreadGroup, command);
        thread.setDaemon(false);
        thread.setName(command.getIdentifier() + "-" + command.getRecord().getId() + "-" + DrupalUtils.getLocalUnixTimestamp());
        int priority = 5;
        if (command.getRecord().getWeight() < -1000L) {
            priority = 10;
        } else if (command.getRecord().getWeight() > 1000L) {
            priority = 1;
        }
        thread.setPriority(priority);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(java.lang.Thread t, Throwable e) {
                assert (t.getClass().isAssignableFrom(Thread.class));
                AsyncCommand command = ((Thread)t).getCommand();
            }
        });
        return thread;
    }

    public static class Thread
    extends java.lang.Thread {
        private AsyncCommand command;

        public Thread(ThreadGroup group, AsyncCommand command) {
            super(group, command);
            this.command = command;
        }

        public AsyncCommand getCommand() {
            return this.command;
        }
    }
}

