/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command.deprecated;

import java.util.Properties;
import org.drupal.project.async_command.deprecated.AbstractDrupalAppDeprecated;
import org.drupal.project.async_command.deprecated.Result;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@Deprecated
public class DefaultDrupalAppDeprecated
extends AbstractDrupalAppDeprecated {
    @Override
    public String identifier() {
        return "default";
    }

    public Result dummy() {
        return this.dummy(null);
    }

    public Result dummy(String message) {
        if (message == null) {
            return new Result(true, "no message");
        }
        if (message.equals("fail me")) {
            return new Result(false, "mission failed.");
        }
        String msg = "You said " + message;
        return new Result(true, msg);
    }

    public static void main(String[] args) {
        DefaultDrupalAppDeprecated app = new DefaultDrupalAppDeprecated();
        app.handleCLI(args);
    }

    public static class TestMe {
        DefaultDrupalAppDeprecated app;

        @Before
        public void setUp() throws Exception {
            this.app = new DefaultDrupalAppDeprecated();
        }

        public void testBasic() throws Exception {
            this.app.testConnection();
            this.app.config.list(System.out);
        }

        @Test
        public void testIdentifier() throws Exception {
            Assert.assertTrue((boolean)this.app.identifier().equals("default"));
        }

        public void testEvalPhp() throws Exception {
            String str = "Hello, world";
            Assert.assertTrue((boolean)this.app.evalPhp("echo \"{0}\";", str).equals(str));
            Assert.assertTrue((boolean)this.app.evalPhp("echo 1;").equals("1"));
            this.app.config.put("php_cli", "/usr/bin/php");
            Assert.assertTrue((boolean)this.app.evalPhp("echo \"{0}\";", str).equals(str));
            this.app.config.remove("php_cli");
        }

        public void testEvalPhpFail() throws Exception {
            this.app.config.put("php_cli", "/usr/bin/phpx");
            Assert.assertTrue((boolean)this.app.evalPhp("echo 1;").equals("1"));
            this.app.config.remove("php_cli");
        }

        @Test
        public void testDecryption() throws Exception {
            this.app.initDrupalConnection();
            String orig = "abc=def";
            String key = this.app.config.getProperty("mcrypt_secret_key");
            Assert.assertNotNull((Object)key);
            String enc = this.app.evalPhp("echo base64_encode(mcrypt_encrypt(MCRYPT_3DES, \"{0}\", \"{1}\", 'ecb'));", key, orig);
            Properties p = this.app.readEncryptedSettingsField(enc, AbstractDrupalAppDeprecated.EncryptionMethod.MCRYPT);
            Assert.assertTrue((boolean)p.getProperty("abc").trim().equals("def"));
        }

        @Test
        public void testDrupalVariable() throws Exception {
            this.app.initDrupalConnection();
            Object value = this.app.drupalVariableGet("anonymous");
            Assert.assertTrue((value.getClass() == String.class ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((String)value).equals("Anonymous"));
            String siteName = (String)this.app.drupalVariableGet("site_name");
            String testSiteName = "site name in test";
            this.app.drupalVariableSet("site_name", testSiteName);
            Assert.assertTrue((boolean)((String)this.app.drupalVariableGet("site_name")).equals(testSiteName));
            this.app.drupalVariableSet("site_name", siteName);
        }

        @Test
        public void testDbUtils() throws Exception {
            this.app.initDrupalConnection();
            long uid = (Long)this.app.queryValue("SELECT uid FROM {users} WHERE uid=1", new Object[0]);
            Assert.assertTrue((uid == 1L ? 1 : 0) != 0);
            Object result = this.app.queryValue("SELECT uid FROM {users} WHERE uid=-1", new Object[0]);
            Assert.assertNull((Object)result);
        }

        @Test
        public void testBatchUpdate() throws Exception {
            this.app.initDrupalConnection();
            this.app.maxBatchSize = 2;
            String s1 = this.app.evalPhp("echo serialize(2);");
            Object[][] params1 = new Object[][]{{"async_command_test1", "1".getBytes()}, {"async_command_test2", s1.getBytes()}, {"async_command_test3", "3".getBytes()}};
            this.app.batch("INSERT INTO {variable}(name, value) VALUES(?, ?)", params1);
            long num1 = (Long)this.app.queryValue("SELECT COUNT(*) FROM {variable} WHERE name LIKE 'async_command_test%'", new Object[0]);
            Assert.assertEquals((long)num1, (long)3L);
            int v1 = (Integer)this.app.drupalVariableGet("async_command_test2");
            Assert.assertEquals((long)v1, (long)2L);
            String s2 = this.app.evalPhp("echo serialize('abc');");
            Object[][] params2 = new Object[][]{{s2.getBytes(), "async_command_test1"}};
            this.app.batch("UPDATE {variable} SET value=? WHERE name=?", params2);
            String v2 = (String)this.app.drupalVariableGet("async_command_test1");
            Assert.assertEquals((Object)v2, (Object)"abc");
            this.app.maxBatchSize = 0;
            Object[][] params3 = new Object[][]{{"async_command_test1"}, {"async_command_test2"}, {"async_command_test3"}};
            this.app.batch("DELETE FROM {variable} WHERE name=?", params3);
            long num2 = (Long)this.app.queryValue("SELECT COUNT(*) FROM {variable} WHERE name LIKE 'async_command_test%'", new Object[0]);
            Assert.assertEquals((long)num2, (long)0L);
        }

        @Test
        public void testQueryValue() throws Exception {
            this.app.initDrupalConnection();
            Object o = this.app.queryValue("SELECT nid FROM {node} WHERE nid=0", new Object[0]);
            Assert.assertNull((Object)o);
            long i = (Long)this.app.queryValue("SELECT COUNT(*) FROM {variable}", new Object[0]);
            Assert.assertTrue((i > 0L ? 1 : 0) != 0);
        }

        public void testReadSettingsPHP() throws Exception {
            System.out.println(this.app.getDefaultSettingsPhpFile());
            Assert.assertTrue((boolean)"/opt/drupal7/sites/default/settings.php".equals(this.app.getDefaultSettingsPhpFile().getAbsolutePath()));
            this.app.loadSettingsPhp(this.app.getDefaultSettingsPhpFile());
            String url = this.app.config.getProperty("url");
            Assert.assertTrue((boolean)url.equals("jdbc:mysql://localhost/drupal7"));
        }

        @Test
        public void testRetrievePendingCommand() {
        }
    }
}

