/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command.test;

import java.sql.Connection;
import junit.framework.Assert;
import org.drupal.project.async_command.BatchUploader;
import org.drupal.project.async_command.DrupalConnection;
import org.drupal.project.async_command.DrupalUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BatchUploaderTest {
    private DrupalConnection drupalConnection;

    @Before
    public void setUp() throws Exception {
        this.drupalConnection = DrupalConnection.create();
        this.drupalConnection.connect();
        this.drupalConnection.update("CREATE TABLE {async_command_batch_updater} (id INT(10) NOT NULL)", new Object[0]);
    }

    @Test
    public void testBatchUpdater() throws Exception {
        Connection connection = this.drupalConnection.getConnection();
        BatchUploader up = new BatchUploader(null, "TestUploader", connection, this.drupalConnection.d("INSERT INTO {async_command_batch_updater} VALUES(?)"), 10);
        up.start();
        for (int i = 0; i < 100; ++i) {
            up.put(i);
        }
        up.accomplish();
        System.out.println("Finished adding data to database.");
        up.join();
        System.out.println("Finished uploading.");
        long n1 = DrupalUtils.getLong(this.drupalConnection.queryValue("SELECT count(*) FROM {async_command_batch_updater}", new Object[0]));
        Assert.assertEquals((long)n1, (long)100L);
        long n2 = DrupalUtils.getLong(this.drupalConnection.queryValue("SELECT count(*) FROM {async_command_batch_updater} WHERE id < 50", new Object[0]));
        Assert.assertEquals((long)n2, (long)50L);
    }

    @After
    public void tearDown() throws Exception {
        this.drupalConnection.update("DROP TABLE {async_command_batch_updater}", new Object[0]);
    }
}

