/*
 * Decompiled with CFR 0.152.
 */
package org.drupal.project.async_command.test;

import java.sql.SQLException;
import java.util.List;
import junit.framework.Assert;
import org.drupal.project.async_command.AsyncCommand;
import org.drupal.project.async_command.CommandRecord;
import org.drupal.project.async_command.DefaultDrupalApp;
import org.drupal.project.async_command.DrupalConnection;
import org.drupal.project.async_command.DrupalUtils;
import org.drupal.project.async_command.GenericDrupalApp;
import org.junit.Test;

public class DefaultDrupalAppTest {
    @Test
    public void testPingMe() throws SQLException {
        String output = DrupalUtils.executeDrush("async-command", "default", "PingMe", "From UnitTest", "string1=Hello");
        System.out.println("Drush output: " + output);
        DrupalConnection drupalConnection = DrupalConnection.create();
        drupalConnection.connect();
        Long id = DrupalUtils.getLong(drupalConnection.queryValue("SELECT max(id) FROM {async_command}", new Object[0]));
        DefaultDrupalApp drupalApp = new DefaultDrupalApp(drupalConnection);
        drupalApp.run();
        drupalConnection.connect(true);
        Assert.assertTrue((boolean)output.trim().endsWith(id.toString()));
        CommandRecord record = drupalConnection.retrieveCommandRecord(id);
        Assert.assertTrue((boolean)record.getStatus().equals((Object)AsyncCommand.Status.SUCCESS));
        Assert.assertTrue((boolean)record.getMessage().endsWith("Hello"));
    }

    @Test
    public void testParallel() throws SQLException {
        DrupalConnection drupalConnection = DrupalConnection.create();
        drupalConnection.connect();
        DrupalUtils.executeDrush("async-command", "default", "PingMe", "Test parallel (from UnitTest)", "string1=medium|number1=5000|number3=-1");
        Long id1 = DrupalUtils.getLong(drupalConnection.queryValue("SELECT max(id) FROM {async_command}", new Object[0]));
        DrupalUtils.executeDrush("async-command", "default", "PingMe", "Test parallel (from UnitTest)", "string1=short|number1=1000|number3=-1");
        Long id2 = DrupalUtils.getLong(drupalConnection.queryValue("SELECT max(id) FROM {async_command}", new Object[0]));
        DrupalUtils.executeDrush("async-command", "default", "PingMe", "Test parallel (from UnitTest)", "string1=long|number1=10000|number3=-1");
        Long id3 = DrupalUtils.getLong(drupalConnection.queryValue("SELECT max(id) FROM {async_command}", new Object[0]));
        DefaultDrupalApp drupalApp = new DefaultDrupalApp(drupalConnection);
        drupalApp.setRunningMode(GenericDrupalApp.RunningMode.PARALLEL);
        drupalApp.run();
        drupalConnection.connect(true);
        List<Object[]> results = drupalConnection.queryArray("SELECT id FROM {async_command} WHERE end IS NOT NULL AND app='default' AND command='PingMe' AND number3=-1 ORDER BY end DESC", new Object[0]);
        Assert.assertTrue((boolean)id3.equals(DrupalUtils.getLong(results.get(0)[0])));
        Assert.assertTrue((boolean)id1.equals(DrupalUtils.getLong(results.get(1)[0])));
        Assert.assertTrue((boolean)id2.equals(DrupalUtils.getLong(results.get(2)[0])));
    }
}

