package org.drupal.project.async_command;

/**
 * Simple command to test Drupal database connection.
 */
public class PingMe extends AsyncCommand {

    private String pingMessage;
    private String pongMessage;
    private Long sleepTime;

    public PingMe(CommandRecord record, GenericDrupalApp drupalApp) {
        super(record, drupalApp);
        initialize(record.getString1(), DrupalUtils.getLong(record.getNumber1()));
    }

    public void initialize(String pingMessage, Long sleepTime) {
        this.pingMessage = pingMessage;
        this.sleepTime = sleepTime;
    }

    @Override
    public void run() {
        record.setStart(DrupalUtils.getLocalUnixTimestamp());
        if (sleepTime != null) {
            try {
                logger.info("PingMe sleeps for " + sleepTime + " milliseconds.");
                Thread.currentThread().sleep(sleepTime);
            } catch (InterruptedException e) {
                record.setStatus(Status.FAILURE);
                record.setMessage("Interrupted while PingMe sleeps.");
                record.setEnd(DrupalUtils.getLocalUnixTimestamp());
                return;
            }
        }

        if (pingMessage != null) {
            pongMessage = "Pong with message: " + pingMessage;
        } else {
            pongMessage = "Pong.";
        }

        // finish up.
        record.setStatus(Status.SUCCESS);
        record.setMessage(pongMessage);
        record.setEnd(DrupalUtils.getLocalUnixTimestamp());
    }
}
