<?php

namespace Drupal\at_ls\Routing;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\entity\Routing\AdminHtmlRouteProvider;
use Symfony\Component\Routing\Route;

/**
 * Provides routes for the AT-LS Translation Request entity.
 */
class AtlsTranslationRequestRouteProvider extends AdminHtmlRouteProvider {

  /**
   * {@inheritdoc}
   */
  public function getRoutes(EntityTypeInterface $entity_type) {
    $collection = parent::getRoutes($entity_type);

    $entity_type_id = $entity_type->id();

    if ($form_route = $this->getProcessRoute($entity_type)) {
      $collection->add("entity.$entity_type_id.process_form", $form_route);
    }

    return $collection;
  }

  /**
   * Gets a process AT-LS Translation Request form route.
   *
   * @param \Drupal\Core\Entity\EntityTypeInterface $entity_type
   *   The entity type.
   *
   * @return \Symfony\Component\Routing\Route|null
   *   The generated route, if available.
   */
  protected function getProcessRoute(EntityTypeInterface $entity_type): ?Route {
    $process_route = NULL;

    if ($entity_type->hasLinkTemplate('process-form')) {
      $entity_type_id = $entity_type->id();

      $route = new Route($entity_type->getLinkTemplate('process-form'));
      $route
        ->addDefaults([
          '_entity_form' => "$entity_type_id.process",
          '_title_callback' => '\Drupal\Core\Entity\Controller\EntityController::title',
        ])
        ->setRequirement('_custom_access', '\Drupal\at_ls\Access\AtlsTranslationRequestAccessCheck::checkProcess')
        ->setOption('parameters', [
          $entity_type_id => [
            'type' => "entity:$entity_type_id",
          ],
        ])
        ->setRequirement($entity_type_id, '\d+')
        ->setOption('_admin_route', TRUE);

      $process_route = $route;
    }
    return $process_route;
  }

}
