<?php

namespace Drupal\at_ls\Http;

use Drupal\Core\Logger\LoggerChannelInterface;
use GuzzleHttp\Client;

/**
 * Defines the Guzzle Http Client.
 */
class GuzzleHttpClient implements HttpClientInterface {

  /**
   * The Http client.
   *
   * @var \GuzzleHttp\Client
   */
  protected $client;

  /**
   * The at_ls logging channel.
   *
   * @var \Drupal\Core\Logger\LoggerChannelInterface
   */
  protected $logger;

  /**
   * Constructs a new HttpClient object.
   *
   * @param \Drupal\Core\Logger\LoggerChannelInterface $logger
   *   The LoggerChannelFactoryInterface object.
   */
  public function __construct(LoggerChannelInterface $logger) {
    $this->client = new Client();
    $this->logger = $logger;
  }

  /**
   * {@inheritdoc}
   */
  public function handleRequest(string $method, string $uri, array $options = []): ?string {
    try {
      $response = $this->client->request($method, $uri, $options);

      return $response->getBody()->getContents();
    }
    catch (\Exception $exception) {
      $this->logger->error($exception->getMessage());
      return NULL;
    }
  }

}
