<?php

namespace Drupal\at_ls;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;

/**
 * Provides a list controller for the AT-LS string entity type.
 */
final class AtlsStringListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['id'] = $this->t('ID');
    $header['created'] = $this->t('Created');
    $header['changed'] = $this->t('Updated');
    $header['source_language'] = $this->t('Source language');
    $header['target_language'] = $this->t('Target language');
    $header['source_text'] = $this->t('Source text');
    $header['target_text'] = $this->t('Target text');

    return $header;
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\at_ls\Entity\AtlsStringInterface $entity */
    $row['id'] = $entity->toLink($entity->id());
    $row['created']['data'] = $entity->get('created')->view(['label' => 'hidden']);
    $row['changed']['data'] = $entity->get('changed')->view(['label' => 'hidden']);
    $row['source_language'] = $entity->get('source_language')->value;
    $row['target_language'] = $entity->get('target_language')->value;
    $row['source_text'] = $entity->get('source_text')->value;
    $row['target_text'] = $entity->get('target_text')->value;

    return $row;
  }

}
