<?php

namespace Drupal\at_ls\Controller;

use Drupal\at_ls\Service\AtlsApiManagerInterface;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Datetime\DrupalDateTime;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Controller to test API calls.
 *
 * Note: This controller is only for testing purposes on the development phase.
 * Please, remove it when the development phase is completed.
 */
class TestResponse extends ControllerBase {

  /**
   * The API manager.
   */
  protected AtlsApiManagerInterface $apiManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->apiManager = $container->get('at_ls.api_manager');

    return $instance;
  }

  /**
   * Route response method for testing delete file by token API call.
   */
  public function testDeleteFileByToken(string $token) {
    $response = $this->apiManager->deleteFileByToken($token, 'es');

    return new JsonResponse($response);
  }

  /**
   * Route response method for testing get file by token API call.
   */
  public function testGetFileByToken(string $token) {
    $response = $this->apiManager->getFileByToken($token, 'es');

    return new JsonResponse($response);
  }

  /**
   * Route response method for testing getlist API call.
   */
  public function testGetList() {
    $response = $this->apiManager->getList(
      'es',
      'en',
      new DrupalDateTime('2020-01-01'),
    );

    return new JsonResponse($response);
  }

  /**
   * Route response method for testing ping API call.
   */
  public function testPing() {
    $response = $this->apiManager->ping();

    return new JsonResponse($response);
  }

  /**
   * Route response method for testing translateAsynchronous API call.
   */
  public function testTranslateAsynchronous() {
    $response = $this->apiManager->translateAsynchronous(
      'es',
      'en',
      'example3.txt',
      'la prueba quinta'
    );

    return new JsonResponse($response);
  }

  /**
   * Route response method for testing translateSynchronous API call.
   */
  public function testTranslateSynchronous() {
    $response = $this->apiManager->translateSynchronous(
      'es',
      'en',
      'example3.txt',
      'buenas noches'
    );

    return new JsonResponse($response);
  }

}
