<?php

namespace Drupal\at_ls\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining an AT-LS translation request entity type.
 */
interface AtlsTranslationRequestInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * The status workflow ID.
   *
   * @var string
   */
  const WORKFLOW_ID = 'translation_request_default';

  /**
   * The init status state.
   *
   * @var string
   */
  const INIT_WORKFLOW_STATE = 'pending';

  /**
   * Checks if the entity can be processed.
   *
   * @return bool
   *   TRUE if has the processable state, otherwise FALSE.
   */
  public function isProcessable(): bool;

  /**
   * Gets the processable state.
   *
   * @return string
   *   The processable state.
   */
  public static function getProcessableState(): string;

}
