<?php

namespace Drupal\at_ls\Event;

use Drupal\at_ls\Entity\AtlsTranslationRequestInterface;
use Drupal\Component\EventDispatcher\Event;

/**
 * Defines the AT-LS translation request event.
 */
class AtlsTranslationRequestEvent extends Event {

  const INSERT = 'at_ls_translation_request_insert';
  const PROCESS = 'at_ls_translation_request_process';

  /**
   * The AT-LS translation request entity.
   *
   * @var \Drupal\at_ls\Entity\AtlsTranslationRequestInterface
   */
  public AtlsTranslationRequestInterface $translationRequest;

  /**
   * Constructs the object.
   *
   * @param \Drupal\at_ls\Entity\AtlsTranslationRequestInterface $translation_request
   *   The AT-LS translation request entity.
   */
  public function __construct(AtlsTranslationRequestInterface $translation_request) {
    $this->translationRequest = $translation_request;
  }

  /**
   * Gets the AT-LS translation request.
   *
   * @return \Drupal\at_ls\Entity\AtlsTranslationRequestInterface
   *   Gets the AT-LS translation request.
   */
  public function getTranslationRequest() {
    return $this->translationRequest;
  }

}
